<?php
/**
 * @license MIT
 *
 * Modified by impress-org on 01-May-2024 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace Give\Vendors\Faker\Provider\ja_JP;

class Text extends \Give\Vendors\Faker\Provider\Text
{
    protected static $separator = '';
    protected static $separatorLen = 0;

    /**
     * All punctuation in $baseText: 、 。 「 」 『 』 ！ ？ ー ， ： ；
     */
    protected static $notEndPunct = ['、', '「', '『', 'ー', '，', '：', '；'];
    protected static $endPunct = ['。', '」', '』', '！', '？'];
    protected static $notBeginPunct = ['、', '。', '」', '』', '！', '？', 'ー', '，', '：', '；'];

    /**
     * Title: 銀河鉄道の夜 Night On The Milky Way Train
     * Author: 宮沢賢治 Kenji Miyazawa
     * Language: Japanese
     *
     * @see http://www.aozora.gr.jp/cards/000081/files/43737_19215.html
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
一　午後の授業

「ではみなさんは、そういうふうに川だと言いわれたり、乳ちちの流ながれたあとだと言いわれたりしていた、このぼんやりと白いものがほんとうは何かご承知しょうちですか」先生は、黒板こくばんにつるした大きな黒い星座せいざの図の、上から下へ白くけぶった銀河帯ぎんがたいのようなところを指さしながら、みんなに問といをかけました。
カムパネルラが手をあげました。それから四、五人手をあげました。ジョバンニも手をあげようとして、急いそいでそのままやめました。たしかにあれがみんな星だと、いつか雑誌ざっしで読んだのでしたが、このごろはジョバンニはまるで毎日教室でもねむく、本を読むひまも読む本もないので、なんだかどんなこともよくわからないという気持きもちがするのでした。
ところが先生は早くもそれを見つけたのでした。
「ジョバンニさん。あなたはわかっているのでしょう」
ジョバンニは勢いきおいよく立ちあがりましたが、立ってみるともうはっきりとそれを答えることができないのでした。ザネリが前の席せきからふりかえって、ジョバンニを見てくすっとわらいました。ジョバンニはもうどぎまぎしてまっ赤になってしまいました。先生がまた言いいました。
「大きな望遠鏡ぼうえんきょうで銀河ぎんがをよっく調しらべると銀河ぎんがはだいたい何でしょう」
やっぱり星だとジョバンニは思いましたが、こんどもすぐに答えることができませんでした。
先生はしばらく困こまったようすでしたが、眼めをカムパネルラの方へ向むけて、
「ではカムパネルラさん」と名指なざしました。
するとあんなに元気に手をあげたカムパネルラが、やはりもじもじ立ち上がったままやはり答えができませんでした。
先生は意外いがいなようにしばらくじっとカムパネルラを見ていましたが、急いそいで、
「では、よし」と言いいながら、自分で星図を指さしました。
「このぼんやりと白い銀河ぎんがを大きないい望遠鏡ぼうえんきょうで見ますと、もうたくさんの小さな星に見えるのです。ジョバンニさんそうでしょう」
ジョバンニはまっ赤かになってうなずきました。けれどもいつかジョバンニの眼めのなかには涙なみだがいっぱいになりました。そうだ僕ぼくは知っていたのだ、もちろんカムパネルラも知っている、それはいつかカムパネルラのお父さんの博士はかせのうちでカムパネルラといっしょに読んだ雑誌ざっしのなかにあったのだ。それどこでなくカムパネルラは、その雑誌ざっしを読むと、すぐお父さんの書斎しょさいから巨おおきな本をもってきて、ぎんがというところをひろげ、まっ黒な頁ページいっぱいに白に点々てんてんのある美うつくしい写真しゃしんを二人でいつまでも見たのでした。それをカムパネルラが忘わすれるはずもなかったのに、すぐに返事へんじをしなかったのは、このごろぼくが、朝にも午後にも仕事しごとがつらく、学校に出てももうみんなともはきはき遊あそばず、カムパネルラともあんまり物を言いわないようになったので、カムパネルラがそれを知ってきのどくがってわざと返事へんじをしなかったのだ、そう考えるとたまらないほど、じぶんもカムパネルラもあわれなような気がするのでした。
先生はまた言いいました。
「ですからもしもこの天の川がほんとうに川だと考えるなら、その一つ一つの小さな星はみんなその川のそこの砂すなや砂利じゃりの粒つぶにもあたるわけです。またこれを巨おおきな乳ちちの流ながれと考えるなら、もっと天の川とよく似にています。つまりその星はみな、乳ちちのなかにまるで細こまかにうかんでいる脂油あぶらの球たまにもあたるのです。そんなら何がその川の水にあたるかと言いいますと、それは真空しんくうという光をある速はやさで伝つたえるもので、太陽たいようや地球ちきゅうもやっぱりそのなかに浮うかんでいるのです。つまりは私わたしどもも天の川の水のなかに棲すんでいるわけです。そしてその天の川の水のなかから四方を見ると、ちょうど水が深いほど青く見えるように、天の川の底そこの深ふかく遠いところほど星がたくさん集まって見え、したがって白くぼんやり見えるのです。この模型もけいをごらんなさい」
先生は中にたくさん光る砂すなのつぶのはいった大きな両面りょうめんの凸とつレンズを指さしました。
「天の川の形はちょうどこんななのです。このいちいちの光るつぶがみんな私わたしどもの太陽たいようと同じようにじぶんで光っている星だと考えます。私どもの太陽たいようがこのほぼ中ごろにあって地球ちきゅうがそのすぐ近くにあるとします。みなさんは夜にこのまん中に立ってこのレンズの中を見まわすとしてごらんなさい。こっちの方はレンズが薄うすいのでわずかの光る粒つぶすなわち星しか見えないでしょう。こっちやこっちの方はガラスが厚あついので、光る粒つぶすなわち星がたくさん見えその遠いのはぼうっと白く見えるという、これがつまり今日の銀河ぎんがの説せつなのです。そんならこのレンズの大きさがどれくらいあるか、またその中のさまざまの星についてはもう時間ですから、この次つぎの理科の時間にお話します。では今日はその銀河ぎんがのお祭まつりなのですから、みなさんは外へでてよくそらをごらんなさい。ではここまでです。本やノートをおしまいなさい」
そして教室じゅうはしばらく机つくえの蓋ふたをあけたりしめたり本を重かさねたりする音がいっぱいでしたが、まもなくみんなはきちんと立って礼れいをすると教室を出ました。

二　活版所かっぱんじょ

ジョバンニが学校の門を出るとき、同じ組の七、八人は家へ帰らずカムパネルラをまん中にして校庭こうていの隅すみの桜さくらの木のところに集あつまっていました。それはこんやの星祭ほしまつりに青いあかりをこしらえて川へ流ながす烏瓜からすうりを取とりに行く相談そうだんらしかったのです。
けれどもジョバンニは手を大きく振ふってどしどし学校の門もんを出て来ました。すると町の家々ではこんやの銀河ぎんがの祭まつりにいちいの葉はの玉たまをつるしたり、ひのきの枝えだにあかりをつけたり、いろいろしたくをしているのでした。
家へは帰らずジョバンニが町を三つ曲まがってある大きな活版所かっぱんじょにはいって靴くつをぬいで上がりますと、突つき当たりの大きな扉とびらをあけました。中にはまだ昼ひるなのに電燈でんとうがついて、たくさんの輪転機りんてんきがばたりばたりとまわり、きれで頭をしばったりラムプシェードをかけたりした人たちが、何か歌うように読んだり数えたりしながらたくさん働はたらいておりました。
ジョバンニはすぐ入口から三番目の高い卓子テーブルにすわった人の所ところへ行っておじぎをしました。その人はしばらく棚たなをさがしてから、
「これだけ拾ひろって行けるかね」と言いいながら、一枚の紙切れを渡わたしました。ジョバンニはその人の卓子テーブルの足もとから一つの小さな平ひらたい函はこをとりだして向むこうの電燈でんとうのたくさんついた、たてかけてある壁かべの隅すみの所ところへしゃがみ込こむと、小さなピンセットでまるで粟粒あわつぶぐらいの活字かつじを次つぎから次つぎへと拾ひろいはじめました。青い胸むねあてをした人がジョバンニのうしろを通りながら、
「よう、虫めがね君くん、お早う」と言いいますと、近くの四、五人の人たちが声もたてずこっちも向むかずに冷つめたくわらいました。
ジョバンニは何べんも眼めをぬぐいながら活字かつじをだんだんひろいました。
六時がうってしばらくたったころ、ジョバンニは拾ひろった活字かつじをいっぱいに入れた平ひらたい箱はこをもういちど手にもった紙きれと引き合わせてから、さっきの卓子テーブルの人へ持もって来ました。その人は黙だまってそれを受うけ取とってかすかにうなずきました。
ジョバンニはおじぎをすると扉とびらをあけて計算台のところに来ました。すると白服しろふくを着きた人がやっぱりだまって小さな銀貨ぎんかを一つジョバンニに渡わたしました。ジョバンニはにわかに顔いろがよくなって威勢いせいよくおじぎをすると、台の下に置おいた鞄かばんをもっておもてへ飛とびだしました。それから元気よく口笛くちぶえを吹ふきながらパン屋やへ寄よってパンの塊かたまりを一つと角砂糖かくざとうを一袋ふくろ買いますといちもくさんに走りだしました。

三　家

ジョバンニが勢いきおいよく帰って来たのは、ある裏町うらまちの小さな家でした。その三つならんだ入口のいちばん左側ひだりがわには空箱あきばこに紫むらさきいろのケールやアスパラガスが植うえてあって小さな二つの窓まどには日覆ひおおいがおりたままになっていました。
「お母さん、いま帰ったよ。ぐあい悪わるくなかったの」ジョバンニは靴くつをぬぎながら言いました。
「ああ、ジョバンニ、お仕事しごとがひどかったろう。今日きょうは涼すずしくてね。わたしはずうっとぐあいがいいよ」
ジョバンニは玄関げんかんを上がって行きますとジョバンニのお母さんがすぐ入口の室へやに白い巾きれをかぶって寝やすんでいたのでした。ジョバンニは窓まどをあけました。
「お母さん、今日は角砂糖かくざとうを買ってきたよ。牛乳ぎゅうにゅうに入れてあげようと思って」
「ああ、お前さきにおあがり。あたしはまだほしくないんだから」
「お母さん。姉ねえさんはいつ帰ったの」
「ああ、三時ころ帰ったよ。みんなそこらをしてくれてね」
「お母さんの牛乳ぎゅうにゅうは来ていないんだろうか」
「来なかったろうかねえ」
「ぼく行ってとって来よう」
「ああ、あたしはゆっくりでいいんだからお前さきにおあがり、姉ねえさんがね、トマトで何かこしらえてそこへ置おいて行ったよ」
「ではぼくたべよう」
ジョバンニは［＃「　ジョバンニは」は底本では「「ジョバンニは」］窓まどのところからトマトの皿さらをとってパンといっしょにしばらくむしゃむしゃたべました。
「ねえお母さん。ぼくお父さんはきっとまもなく帰ってくると思うよ」
「ああ、あたしもそう思う。けれどもおまえはどうしてそう思うの」
「だって今朝けさの新聞に今年は北の方の漁りょうはたいへんよかったと書いてあったよ」
「ああだけどねえ、お父さんは漁りょうへ出ていないかもしれない」
「きっと出ているよ。お父さんが監獄かんごくへはいるようなそんな悪わるいことをしたはずがないんだ。この前お父さんが持ってきて学校へ寄贈きぞうした巨おおきな蟹かにの甲こうらだのとなかいの角つのだの今だってみんな標本室ひょうほんしつにあるんだ。六年生なんか授業じゅぎょうのとき先生がかわるがわる教室へ持もって行くよ」
「お父さんはこの次つぎはおまえにラッコの上着うわぎをもってくるといったねえ」
「みんながぼくにあうとそれを言いうよ。ひやかすように言いうんだ」
「おまえに悪口わるくちを言いうの」
「うん、けれどもカムパネルラなんか決けっして言いわない。カムパネルラはみんながそんなことを言いうときはきのどくそうにしているよ」
「カムパネルラのお父さんとうちのお父さんとは、ちょうどおまえたちのように小さいときからのお友達ともだちだったそうだよ」
「ああだからお父さんはぼくをつれてカムパネルラのうちへもつれて行ったよ。あのころはよかったなあ。ぼくは学校から帰る途中とちゅうたびたびカムパネルラのうちに寄よった。カムパネルラのうちにはアルコールランプで走る汽車があったんだ。レールを七つ組み合わせるとまるくなってそれに電柱でんちゅうや信号標しんごうひょうもついていて信号標しんごうひょうのあかりは汽車が通るときだけ青くなるようになっていたんだ。いつかアルコールがなくなったとき石油せきゆをつかったら、缶かんがすっかりすすけたよ」
「そうかねえ」
「いまも毎朝新聞をまわしに行くよ。けれどもいつでも家じゅうまだしいんとしているからな」
「早いからねえ」
「ザウエルという犬がいるよ。しっぽがまるで箒ほうきのようだ。ぼくが行くと鼻はなを鳴らしてついてくるよ。ずうっと町の角かどまでついてくる。もっとついてくることもあるよ。今夜はみんなで烏瓜からすうりのあかりを川へながしに行くんだって。きっと犬もついて行くよ」
「そうだ。今晩こんばんは銀河ぎんがのお祭まつりだねえ」
「うん。ぼく牛乳ぎゅうにゅうをとりながら見てくるよ」
「ああ行っておいで。川へははいらないでね」
「ああぼく岸きしから見るだけなんだ。一時間で行ってくるよ」
「もっと遊あそんでおいで。カムパネルラさんといっしょなら心配しんぱいはないから」
「ああきっといっしょだよ。お母さん、窓をしめておこうか」
「ああ、どうか。もう涼すずしいからね」
ジョバンニは立って窓まどをしめ、お皿さらやパンの袋ふくろをかたづけると勢いきおいよく靴くつをはいて、
「では一時間半はんで帰ってくるよ」と言いいながら暗くらい戸口とぐちを出ました。

四　ケンタウル祭さいの夜

ジョバンニは、口笛くちぶえを吹ふいているようなさびしい口つきで、檜ひのきのまっ黒にならんだ町の坂さかをおりて来たのでした。
坂さかの下に大きな一つの街燈がいとうが、青白く立派りっぱに光って立っていました。ジョバンニが、どんどん電燈でんとうの方へおりて行きますと、いままでばけもののように、長くぼんやり、うしろへ引いていたジョバンニの影かげぼうしは、だんだん濃こく黒くはっきりなって、足をあげたり手を振ふったり、ジョバンニの横よこの方へまわって来るのでした。
（ぼくは立派りっぱな機関車きかんしゃだ。ここは勾配こうばいだから速はやいぞ。ぼくはいまその電燈でんとうを通り越こす。そうら、こんどはぼくの影法師かげぼうしはコンパスだ。あんなにくるっとまわって、前の方へ来た）
とジョバンニが思いながら、大股おおまたにその街燈がいとうの下を通り過すぎたとき、いきなりひるまのザネリが、新しいえりのとがったシャツを着きて、電燈でんとうの向むこう側がわの暗くらい小路こうじから出て来て、ひらっとジョバンニとすれちがいました。
「ザネリ、烏瓜からすうりながしに行くの」ジョバンニがまだそう言いってしまわないうちに、
「ジョバンニ、お父さんから、ラッコの上着うわぎが来るよ」その子が投なげつけるようにうしろから叫さけびました。
ジョバンニは、ばっと胸むねがつめたくなり、そこらじゅうきいんと鳴るように思いました。
「なんだい、ザネリ」とジョバンニは高く叫さけび返かえしましたが、もうザネリは向むこうのひばの植うわった家の中へはいっていました。
（ザネリはどうしてぼくがなんにもしないのにあんなことを言いうのだろう。走るときはまるで鼠ねずみのようなくせに。ぼくがなんにもしないのにあんなことを言いうのはザネリがばかなからだ）
ジョバンニは、せわしくいろいろのことを考えながら、さまざまの灯あかりや木の枝えだで、すっかりきれいに飾かざられた街まちを通って行きました。時計屋とけいやの店には明るくネオン燈とうがついて、一秒びょうごとに石でこさえたふくろうの赤い眼めが、くるっくるっとうごいたり、いろいろな宝石ほうせきが海のような色をした厚あつい硝子ガラスの盤ばんに載のって、星のようにゆっくり循めぐったり、また向むこう側がわから、銅どうの人馬がゆっくりこっちへまわって来たりするのでした。そのまん中にまるい黒い星座早見せいざはやみが青いアスパラガスの葉はで飾かざってありました。
ジョバンニはわれを忘わすれて、その星座せいざの図に見入りました。
それはひる学校で見たあの図よりはずうっと小さかったのですが、その日と時間に合わせて盤ばんをまわすと、そのとき出ているそらがそのまま楕円形だえんけいのなかにめぐってあらわれるようになっており、やはりそのまん中には上から下へかけて銀河ぎんががぼうとけむったような帯おびになって、その下の方ではかすかに爆発ばくはつして湯ゆげでもあげているように見えるのでした。またそのうしろには三本の脚あしのついた小さな望遠鏡ぼうえんきょうが黄いろに光って立っていましたし、いちばんうしろの壁かべには空じゅうの星座せいざをふしぎな獣けものや蛇へびや魚や瓶びんの形に書いた大きな図ずがかかっていました。ほんとうにこんなような蠍さそりだの勇士ゆうしだのそらにぎっしりいるだろうか、ああぼくはその中をどこまでも歩いてみたいと思ってたりしてしばらくぼんやり立っていました。
それからにわかにお母さんの牛乳ぎゅうにゅうのことを思いだしてジョバンニはその店をはなれました。
そしてきゅうくつな上着うわぎの肩かたを気にしながら、それでもわざと胸むねを張はって大きく手を振ふって町を通って行きました。
空気は澄すみきって、まるで水のように通りや店の中を流ながれましたし、街燈がいとうはみなまっ青なもみや楢ならの枝えだで包つつまれ、電気会社の前の六本のプラタナスの木などは、中にたくさんの豆電燈まめでんとうがついて、ほんとうにそこらは人魚の都みやこのように見えるのでした。子どもらは、みんな新しい折おりのついた着物きものを着きて、星めぐりの口笛くちぶえを吹ふいたり、
「ケンタウルス、露つゆをふらせ」と叫さけんで走ったり、青いマグネシヤの花火を燃もしたりして、たのしそうに遊あそんでいるのでした。けれどもジョバンニは、いつかまた深ふかく首くびをたれて、そこらのにぎやかさとはまるでちがったことを考えながら、牛乳屋ぎゅうにゅうやの方へ急いそぐのでした。
ジョバンニは、いつか町はずれのポプラの木が幾本いくほんも幾本いくほんも、高く星ぞらに浮うかんでいるところに来ていました。その牛乳屋ぎゅうにゅうやの黒い門もんをはいり、牛のにおいのするうすくらい台所だいどころの前に立って、ジョバンニは帽子ぼうしをぬいで、
「今晩こんばんは」と言いいましたら、家の中はしいんとして誰だれもいたようではありませんでした。
「今晩こんばんは、ごめんなさい」ジョバンニはまっすぐに立ってまた叫さけびました。するとしばらくたってから、年とった女の人が、どこかぐあいが悪わるいようにそろそろと出て来て、何か用かと口の中で言いいました。
「あの、今日、牛乳ぎゅうにゅうが僕ぼく※［＃小書き平仮名ん、183-7］とこへ来なかったので、もらいにあがったんです」ジョバンニが一生けん命めい勢いきおいよく言いいました。
「いま誰だれもいないでわかりません。あしたにしてください」その人は赤い眼めの下のとこをこすりながら、ジョバンニを見おろして言いいました。
「おっかさんが病気びょうきなんですから今晩こんばんでないと困こまるんです」
「ではもう少したってから来てください」その人はもう行ってしまいそうでした。
「そうですか。ではありがとう」ジョバンニは、お辞儀じぎをして台所だいどころから出ました。
十字になった町のかどを、まがろうとしましたら、向むこうの橋はしへ行く方の雑貨店ざっかてんの前で、黒い影かげやぼんやり白いシャツが入り乱みだれて、六、七人の生徒らが、口笛くちぶえを吹ふいたり笑わらったりして、めいめい烏瓜からすうりの燈火あかりを持もってやって来くるのを見みました。その笑わらい声も口笛くちぶえも、みんな聞きおぼえのあるものでした。ジョバンニの同級どうきゅうの子供こどもらだったのです。ジョバンニは思わずどきっとして戻もどろうとしましたが、思い直なおして、いっそう勢いきおいよくそっちへ歩いて行きました。
「川へ行くの」ジョバンニが言いおうとして、少しのどがつまったように思ったとき、
「ジョバンニ、ラッコの上着うわぎが来るよ」さっきのザネリがまた叫さけびました。
「ジョバンニ、ラッコの上着うわぎが来るよ」すぐみんなが、続つづいて叫さけびました。ジョバンニはまっ赤になって、もう歩いているかもわからず、急いそいで行きすぎようとしましたら、そのなかにカムパネルラがいたのです。カムパネルラはきのどくそうに、だまって少しわらって、おこらないだろうかというようにジョバンニの方を見ていました。
ジョバンニは、にげるようにその眼めを避さけ、そしてカムパネルラのせいの高いかたちが過すぎて行ってまもなく、みんなはてんでに口笛くちぶえを吹ふきました。町かどを曲まがるとき、ふりかえって見ましたら、ザネリがやはりふりかえって見ていました。そしてカムパネルラもまた、高く口笛くちぶえを吹ふいて向むこうにぼんやり見える橋はしの方へ歩いて行ってしまったのでした。ジョバンニは、なんとも言いえずさびしくなって、いきなり走りだしました。すると耳に手をあてて、わあわあと言いいながら片足かたあしでぴょんぴょん跳とんでいた小さな子供こどもらは、ジョバンニがおもしろくてかけるのだと思って、わあいと叫さけびました。
まもなくジョバンニは走りだして黒い丘おかの方へ急いそぎました。

五　天気輪てんきりんの柱はしら

牧場ぼくじょうのうしろはゆるい丘おかになって、その黒い平たいらな頂上ちょうじょうは、北の大熊星おおくまぼしの下に、ぼんやりふだんよりも低ひくく、連つらなって見えました。
ジョバンニは、もう露つゆの降おりかかった小さな林のこみちを、どんどんのぼって行きました。まっくらな草や、いろいろな形に見えるやぶのしげみの間を、その小さなみちが、一すじ白く星あかりに照てらしだされてあったのです。草の中には、ぴかぴか青びかりを出す小さな虫もいて、ある葉はは青くすかし出され、ジョバンニは、さっきみんなの持もって行った烏瓜からすうりのあかりのようだとも思いました。
そのまっ黒な、松まつや楢ならの林を越こえると、にわかにがらんと空がひらけて、天の川がしらしらと南から北へ亙わたっているのが見え、また頂いただきの、天気輪てんきりんの柱はしらも見わけられたのでした。つりがねそうか野ぎくかの花が、そこらいちめんに、夢ゆめの中からでもかおりだしたというように咲さき、鳥が一疋ぴき、丘おかの上を鳴き続つづけながら通って行きました。
ジョバンニは、頂いただきの天気輪てんきりんの柱はしらの下に来て、どかどかするからだを、つめたい草に投なげました。
町の灯あかりは、暗やみの中をまるで海の底そこのお宮みやのけしきのようにともり、子供こどもらの歌う声や口笛くちぶえ、きれぎれの叫さけび声もかすかに聞こえて来るのでした。風が遠くで鳴り、丘おかの草もしずかにそよぎ、ジョバンニの汗あせでぬれたシャツもつめたく冷ひやされました。
野原から汽車の音が聞こえてきました。その小さな列車れっしゃの窓まどは一列いちれつ小さく赤く見え、その中にはたくさんの旅人たびびとが、苹果りんごをむいたり、わらったり、いろいろなふうにしていると考えますと、ジョバンニは、もうなんとも言いえずかなしくなって、また眼めをそらに挙あげました。
（この間原稿げんこう五枚分まいぶんなし）
ところがいくら見ていても、そのそらは、ひる先生の言いったような、がらんとした冷つめたいとこだとは思われませんでした。それどころでなく、見れば見るほど、そこは小さな林や牧場ぼくじょうやらある野原のはらのように考えられてしかたなかったのです。そしてジョバンニは青い琴ことの星が、三つにも四つにもなって、ちらちらまたたき、脚あしが何べんも出たり引っ込こんだりして、とうとう蕈きのこのように長く延のびるのを見ました。またすぐ眼めの下のまちまでが、やっぱりぼんやりしたたくさんの星の集あつまりか一つの大きなけむりかのように見えるように思いました。

六　銀河ぎんがステーション

そしてジョバンニはすぐうしろの天気輪てんきりんの柱はしらがいつかぼんやりした三角標さんかくひょうの形になって、しばらく蛍ほたるのように、ぺかぺか消きえたりともったりしているのを見ました。それはだんだんはっきりして、とうとうりんとうごかないようになり、濃こい鋼青はがねのそらの野原にたちました。いま新しく灼やいたばかりの青い鋼はがねの板いたのような、そらの野原に、まっすぐにすきっと立ったのです。
するとどこかで、ふしぎな声が、銀河ぎんがステーション、銀河ぎんがステーションと言いう声がしたと思うと、いきなり眼めの前が、ぱっと明るくなって、まるで億万おくまんの蛍烏賊ほたるいかの火を一ぺんに化石かせきさせて、そらじゅうに沈しずめたというぐあい、またダイアモンド会社で、ねだんがやすくならないために、わざと穫とれないふりをして、かくしておいた金剛石こんごうせきを、誰だれかがいきなりひっくりかえして、ばらまいたというふうに、眼めの前がさあっと明るくなって、ジョバンニは、思わず何べんも眼めをこすってしまいました。
気がついてみると、さっきから、ごとごとごとごと、ジョバンニの乗のっている小さな列車れっしゃが走りつづけていたのでした。ほんとうにジョバンニは、夜の軽便鉄道けいべんてつどうの、小さな黄いろの電燈でんとうのならんだ車室に、窓まどから外を見ながらすわっていたのです。車室の中は、青い天鵞絨ビロードを張はった腰掛こしかけが、まるでがらあきで、向むこうの鼠ねずみいろのワニスを塗ぬった壁かべには、真鍮しんちゅうの大きなぼたんが二つ光っているのでした。
すぐ前の席せきに、ぬれたようにまっ黒な上着うわぎを着た、せいの高い子供こどもが、窓から頭を出して外を見ているのに気がつきました。そしてそのこどもの肩かたのあたりが、どうも見たことのあるような気がして、そう思うと、もうどうしても誰だれだかわかりたくて、たまらなくなりました。いきなりこっちも窓まどから顔を出そうとしたとき、にわかにその子供こどもが頭を引っ込こめて、こっちを見ました。
それはカムパネルラだったのです。ジョバンニが、
カムパネルラ、きみは前からここにいたの、と言いおうと思ったとき、カムパネルラが、
「みんなはね、ずいぶん走ったけれども遅おくれてしまったよ。ザネリもね、ずいぶん走ったけれども追おいつかなかった」と言いいました。
ジョバンニは、
（そうだ、ぼくたちはいま、いっしょにさそって出かけたのだ）とおもいながら、
「どこかで待まっていようか」と言いいました。するとカムパネルラは、
「ザネリはもう帰ったよ。お父さんが迎むかいにきたんだ」
カムパネルラは、なぜかそう言いいながら、少し顔いろが青ざめて、どこか苦くるしいというふうでした。するとジョバンニも、なんだかどこかに、何か忘わすれたものがあるというような、おかしな気持きもちがしてだまってしまいました。
ところがカムパネルラは、窓まどから外をのぞきながら、もうすっかり元気が直なおって、勢いきおいよく言いいました。
「ああしまった。ぼく、水筒すいとうを忘わすれてきた。スケッチ帳ちょうも忘わすれてきた。けれどかまわない。もうじき白鳥の停車場ていしゃばだから。ぼく、白鳥を見るなら、ほんとうにすきだ。川の遠くを飛とんでいたって、ぼくはきっと見える」
そして、カムパネルラは、まるい板いたのようになった地図ちずを、しきりにぐるぐるまわして見ていました。まったく、その中に、白くあらわされた天の川の左の岸きしに沿そって一条じょうの鉄道線路てつどうせんろが、南へ南へとたどって行くのでした。そしてその地図の立派りっぱなことは、夜のようにまっ黒な盤ばんの上に、一々の停車場ていしゃばや三角標さんかくひょう、泉水せんすいや森が、青や橙だいだいや緑みどりや、うつくしい光でちりばめられてありました。
ジョバンニはなんだかその地図をどこかで見たようにおもいました。
「この地図ちずはどこで買ったの。黒曜石こくようせきでできてるねえ」
ジョバンニが言いいました。
「銀河ぎんがステーションで、もらったんだ。君きみもらわなかったの」
「ああ、ぼく銀河ぎんがステーションを通ったろうか。いまぼくたちのいるとこ、ここだろう」
ジョバンニは、白鳥と書いてある停車場ていしゃばのしるしの、すぐ北を指さしました。
「そうだ。おや、あの河原かわらは月夜だろうか」そっちを見ますと、青白く光る銀河ぎんがの岸きしに、銀ぎんいろの空のすすきが、もうまるでいちめん、風にさらさらさらさら、ゆられてうごいて、波なみを立てているのでした。
「月夜でないよ。銀河ぎんがだから光るんだよ」ジョバンニは言いいながら、まるではね上がりたいくらい愉快ゆかいになって、足をこつこつ鳴らし、窓まどから顔を出して、高く高く星めぐりの口笛くちぶえを吹ふきながら一生けん命めい延のびあがって、その天の川の水を、見きわめようとしましたが、はじめはどうしてもそれが、はっきりしませんでした。けれどもだんだん気をつけて見ると、そのきれいな水は、ガラスよりも水素すいそよりもすきとおって、ときどき眼めのかげんか、ちらちら紫むらさきいろのこまかな波なみをたてたり、虹にじのようにぎらっと光ったりしながら、声もなくどんどん流ながれて行き、野原にはあっちにもこっちにも、燐光りんこうの三角標さんかくひょうが、うつくしく立っていたのです。遠いものは小さく、近いものは大きく、遠いものは橙だいだいや黄いろではっきりし、近いものは青白く少しかすんで、あるいは三角形さんかくけい、あるいは四辺形しへんけい、あるいは電いなずまや鎖くさりの形、さまざまにならんで、野原いっぱいに光っているのでした。ジョバンニは、まるでどきどきして、頭をやけに振ふりました。するとほんとうに、そのきれいな野原のはらじゅうの青や橙だいだいや、いろいろかがやく三角標さんかくひょうも、てんでに息をつくように、ちらちらゆれたり顫ふるえたりしました。
「ぼくはもう、すっかり天の野原に来た」ジョバンニは言いいました。
「それに、この汽車石炭せきたんをたいていないねえ」ジョバンニが左手をつき出して窓まどから前の方を見ながら言いいました。
「アルコールか電気だろう」カムパネルラが言いいました。
するとちょうど、それに返事へんじするように、どこか遠くの遠くのもやのもやの中から、セロのようなごうごうした声がきこえて来ました。
「ここの汽車は、スティームや電気でうごいていない。ただうごくようにきまっているからうごいているのだ。ごとごと音をたてていると、そうおまえたちは思っているけれども、それはいままで音をたてる汽車にばかりなれているためなのだ」
「あの声、ぼくなんべんもどこかできいた」
「ぼくだって、林の中や川で、何べんも聞いた」
ごとごとごとごと、その小さなきれいな汽車は、そらのすすきの風にひるがえる中を、天の川の水や、三角点さんかくてんの青じろい微光びこうの中を、どこまでもどこまでもと、走って行くのでした。
「ああ、りんどうの花が咲さいている。もうすっかり秋だねえ」カムパネルラが、窓まどの外を指ゆびさして言いいました。
線路せんろのへりになったみじかい芝草しばくさの中に、月長石げっちょうせきででも刻きざまれたような、すばらしい紫むらさきのりんどうの花が咲さいていました。
「ぼく飛とびおりて、あいつをとって、また飛とび乗のってみせようか」ジョバンニは胸むねをおどらせて言いいました。
「もうだめだ。あんなにうしろへ行ってしまったから」
カムパネルラが、そう言いってしまうかしまわないうち、次つぎのりんどうの花が、いっぱいに光って過すぎて行きました。
と思ったら、もう次つぎから次つぎから、たくさんのきいろな底そこをもったりんどうの花のコップが、湧わくように、雨のように、眼めの前を通り、三角標さんかくひょうの列れつは、けむるように燃もえるように、いよいよ光って立ったのです。

七　北十字きたじゅうじとプリオシン海岸かいがん

「おっかさんは、ぼくをゆるしてくださるだろうか」
いきなり、カムパネルラが、思い切ったというように、少しどもりながら、せきこんで言いいました。
ジョバンニは、
（ああ、そうだ、ぼくのおっかさんは、あの遠い一つのちりのように見える橙だいだいいろの三角標さんかくひょうのあたりにいらっしゃって、いまぼくのことを考えているんだった）と思いながら、ぼんやりしてだまっていました。
「ぼくはおっかさんが、ほんとうに幸さいわいになるなら、どんなことでもする。けれども、いったいどんなことが、おっかさんのいちばんの幸さいわいなんだろう」カムパネルラは、なんだか、泣なきだしたいのを、一生けん命めいこらえているようでした。
「きみのおっかさんは、なんにもひどいことないじゃないの」ジョバンニはびっくりして叫さけびました。
「ぼくわからない。けれども、誰だれだって、ほんとうにいいことをしたら、いちばん幸さいわいなんだねえ。だから、おっかさんは、ぼくをゆるしてくださると思う」カムパネルラは、なにかほんとうに決心けっしんしているように見えました。
にわかに、車のなかが、ぱっと白く明るくなりました。見ると、もうじつに、金剛石こんごうせきや草の露つゆやあらゆる立派りっぱさをあつめたような、きらびやかな銀河ぎんがの河床かわどこの上を、水は声もなくかたちもなく流ながれ、その流ながれのまん中に、ぼうっと青白く後光ごこうの射さした一つの島しまが見えるのでした。その島しまの平たいらないただきに、立派りっぱな眼めもさめるような、白い十字架じゅうじかがたって、それはもう、凍こおった北極ほっきょくの雲で鋳いたといったらいいか、すきっとした金いろの円光をいただいて、しずかに永久えいきゅうに立っているのでした。
「ハレルヤ、ハレルヤ」前からもうしろからも声が起おこりました。ふりかえって見ると、車室の中の旅人たびびとたちは、みなまっすぐにきもののひだを垂たれ、黒いバイブルを胸むねにあてたり、水晶すいしょうの数珠じゅずをかけたり、どの人もつつましく指ゆびを組み合わせて、そっちに祈いのっているのでした。思わず二人ふたりともまっすぐに立ちあがりました。カムパネルラの頬ほおは、まるで熟じゅくした苹果りんごのあかしのようにうつくしくかがやいて見えました。
そして島しまと十字架じゅうじかとは、だんだんうしろの方へうつって行きました。
向むこう岸ぎしも、青じろくぼうっと光ってけむり、時々、やっぱりすすきが風にひるがえるらしく、さっとその銀ぎんいろがけむって、息いきでもかけたように見え、また、たくさんのりんどうの花が、草をかくれたり出たりするのは、やさしい狐火きつねびのように思われました。
それもほんのちょっとの間、川と汽車との間は、すすきの列れつでさえぎられ、白鳥の島しまは、二度どばかり、うしろの方に見えましたが、じきもうずうっと遠く小さく、絵えのようになってしまい、またすすきがざわざわ鳴って、とうとうすっかり見えなくなってしまいました。ジョバンニのうしろには、いつから乗のっていたのか、せいの高い、黒いかつぎをしたカトリックふうの尼あまさんが、まんまるな緑みどりの瞳ひとみを、じっとまっすぐに落おとして、まだ何かことばか声かが、そっちから伝つたわって来るのを、虔つつしんで聞いているというように見えました。旅人たびびとたちはしずかに席せきに戻もどり、二人ふたりも胸むねいっぱいのかなしみに似にた新しい気持きもちを、何気なくちがった語ことばで、そっと談はなし合ったのです。
「もうじき白鳥の停車場ていしゃばだねえ」
「ああ、十一時かっきりには着つくんだよ」
早くも、シグナルの緑みどりの燈と、ぼんやり白い柱はしらとが、ちらっと窓まどのそとを過すぎ、それから硫黄いおうのほのおのようなくらいぼんやりした転てんてつ機きの前のあかりが窓まどの下を通り、汽車はだんだんゆるやかになって、まもなくプラットホームの一列れつの電燈でんとうが、うつくしく規則きそく正しくあらわれ、それがだんだん大きくなってひろがって、二人はちょうど白鳥停車場ていしゃじょうの、大きな時計とけいの前に来てとまりました。
さわやかな秋の時計とけいの盤面ばんめんには、青く灼やかれたはがねの二本の針はりが、くっきり十一時を指さしました。みんなは、一ぺんにおりて、車室の中はがらんとなってしまいました。
〔二十分停車ていしゃ〕と時計とけいの下に書いてありました。
「ぼくたちも降おりて見ようか」ジョバンニが言いいました。
「降おりよう」二人ふたりは一度どにはねあがってドアを飛とび出して改札口かいさつぐちへかけて行きました。ところが改札口かいさつぐちには、明るい紫むらさきがかった電燈でんとうが、一つ点ついているばかり、誰だれもいませんでした。そこらじゅうを見ても、駅長えきちょうや赤帽あかぼうらしい人の、影かげもなかったのです。
二人ふたりは、停車場ていしゃばの前の、水晶細工すいしょうざいくのように見える銀杏いちょうの木に囲かこまれた、小さな広場に出ました。
そこから幅はばの広いみちが、まっすぐに銀河ぎんがの青光あおびかりの中へ通っていました。
さきに降おりた人たちは、もうどこへ行ったか一人ひとりも見えませんでした。二人ふたりがその白い道を、肩かたをならべて行きますと、二人ふたりの影かげは、ちょうど四方に窓まどのある室へやの中の、二本の柱はしらの影かげのように、また二つの車輪しゃりんの輻やのように幾本いくほんも幾本いくほんも四方へ出るのでした。そしてまもなく、あの汽車から見えたきれいな河原かわらに来ました。
カムパネルラは、そのきれいな砂すなを一つまみ、掌てのひらにひろげ、指ゆびできしきしさせながら、夢ゆめのように言いっているのでした。
「この砂すなはみんな水晶すいしょうだ。中で小さな火が燃もえている」
「そうだ」どこでぼくは、そんなことを習ならったろうと思いながら、ジョバンニもぼんやり答えていました。
河原かわらの礫こいしは、みんなすきとおって、たしかに水晶すいしょうや黄玉トパーズや、またくしゃくしゃの皺曲しゅうきょくをあらわしたのや、また稜かどから霧きりのような青白い光を出す鋼玉コランダムやらでした。ジョバンニは、走ってその渚なぎさに行って、水に手をひたしました。けれどもあやしいその銀河ぎんがの水は、水素すいそよりももっとすきとおっていたのです。それでもたしかに流ながれていたことは、二人ふたりの手首てくびの、水にひたったとこが、少し水銀すいぎんいろに浮ういたように見え、その手首てくびにぶっつかってできた波なみは、うつくしい燐光りんこうをあげて、ちらちらと燃もえるように見えたのでもわかりました。
川上の方を見ると、すすきのいっぱいにはえている崖がけの下に、白い岩いわが、まるで運動場うんどうじょうのように平たいらに川に沿そって出ているのでした。そこに小さな五、六人の人かげが、何か掘ほり出すか埋うめるかしているらしく、立ったりかがんだり、時々なにかの道具どうぐが、ピカッと光ったりしました。
「行ってみよう」二人ふたりは、まるで一度どに叫さけんで、そっちの方へ走りました。その白い岩いわになったところの入口に、〔プリオシン海岸かいがん〕という、瀬戸物せともののつるつるした標札ひょうさつが立って、向こうの渚なぎさには、ところどころ、細ほそい鉄てつの欄干らんかんも植うえられ、木製もくせいのきれいなベンチも置おいてありました。
「おや、変へんなものがあるよ」カムパネルラが、不思議ふしぎそうに立ちどまって、岩いわから黒い細長ほそながいさきのとがったくるみの実みのようなものをひろいました。
「くるみの実みだよ。そら、たくさんある。流ながれて来たんじゃない。岩いわの中にはいってるんだ」
「大きいね、このくるみ、倍ばいあるね。こいつはすこしもいたんでない」
「早くあすこへ行って見よう。きっと何か掘ほってるから」
二人ふたりは、ぎざぎざの黒いくるみの実みを持もちながら、またさっきの方へ近よって行きました。左手の渚なぎさには、波なみがやさしい稲妻いなずまのように燃もえて寄よせ、右手の崖がけには、いちめん銀ぎんや貝殻かいがらでこさえたようなすすきの穂ほがゆれたのです。
だんだん近づいて見ると、一人のせいの高い、ひどい近眼鏡きんがんきょうをかけ、長靴ながぐつをはいた学者がくしゃらしい人が、手帳てちょうに何かせわしそうに書きつけながら、つるはしをふりあげたり、スコップをつかったりしている、三人の助手じょしゅらしい人たちに夢中むちゅうでいろいろ指図さしずをしていました。
「そこのその突起とっきをこわさないように、スコップを使いたまえ、スコップを。おっと、も少し遠くから掘ほって。いけない、いけない、なぜそんな乱暴らんぼうをするんだ」
見ると、その白い柔やわらかな岩いわの中から、大きな大きな青じろい獣けものの骨ほねが、横に倒たおれてつぶれたというふうになって、半分以上はんぶんいじょう掘ほり出されていました。そして気をつけて見ると、そこらには、蹄ひづめの二つある足跡あしあとのついた岩いわが、四角しかくに十ばかり、きれいに切り取られて番号ばんごうがつけられてありました。
「君たちは参観さんかんかね」その大学士だいがくしらしい人が、眼鏡めがねをきらっとさせて、こっちを見て話しかけました。
「くるみがたくさんあったろう。それはまあ、ざっと百二十万年まんねんぐらい前のくるみだよ。ごく新しい方さ。ここは百二十万年前まんねんまえ、第三紀だいさんきのあとのころは海岸かいがんでね、この下からは貝かいがらも出る。いま川の流れているとこに、そっくり塩水しおみずが寄よせたり引いたりもしていたのだ。このけものかね、これはボスといってね、おいおい、そこ、つるはしはよしたまえ。ていねいに鑿のみでやってくれたまえ。ボスといってね、いまの牛うしの先祖せんぞで、昔むかしはたくさんいたのさ」
「標本ひょうほんにするんですか」
「いや、証明しょうめいするに要いるんだ。ぼくらからみると、ここは厚あつい立派りっぱな地層ちそうで、百二十万年まんねんぐらい前にできたという証拠しょうこもいろいろあがるけれども、ぼくらとちがったやつからみてもやっぱりこんな地層ちそうに見えるかどうか、あるいは風か水や、がらんとした空かに見えやしないかということなのだ。わかったかい。けれども、おいおい、そこもスコップではいけない。そのすぐ下に肋骨ろっこつが埋うもれてるはずじゃないか」
大学士だいがくしはあわてて走って行きました。
「もう時間だよ。行こう」カムパネルラが地図と腕時計うでどけいとをくらべながら言いいました。
「ああ、ではわたくしどもは失礼しつれいいたします」ジョバンニは、ていねいに大学士だいがくしにおじぎしました。
「そうですか。いや、さよなら」大学士だいがくしは、また忙いそがしそうに、あちこち歩きまわって監督かんとくをはじめました。
二人ふたりは、その白い岩いわの上を、一生けん命めい汽車におくれないように走りました。そしてほんとうに、風のように走れたのです。息いきも切れず膝ひざもあつくなりませんでした。
こんなにしてかけるなら、もう世界せかいじゅうだってかけれると、ジョバンニは思いました。
そして二人ふたりは、前のあの河原かわらを通り、改札口かいさつぐちの電燈でんとうがだんだん大きくなって、まもなく二人ふたりは、もとの車室の席せきにすわっていま行って来た方を、窓まどから見ていました。

八　鳥を捕とる人

「ここへかけてもようございますか」
がさがさした、けれども親切そうな、大人おとなの声が、二人ふたりのうしろで聞こえました。
それは、茶いろの少しぼろぼろの外套がいとうを着きて、白い巾きれでつつんだ荷物にもつを、二つに分けて肩かたに掛かけた、赤髯あかひげのせなかのかがんだ人でした。
「ええ、いいんです」ジョバンニは、少し肩かたをすぼめてあいさつしました。その人は、ひげの中でかすかに微笑わらいながら荷物にもつをゆっくり網棚あみだなにのせました。ジョバンニは、なにかたいへんさびしいようなかなしいような気がして、だまって正面しょうめんの時計とけいを見ていましたら、ずうっと前の方で、硝子ガラスの笛ふえのようなものが鳴りました。汽車はもう、しずかにうごいていたのです。カムパネルラは、車室の天井てんじょうを、あちこち見ていました。その一つのあかりに黒い甲虫かぶとむしがとまって、その影かげが大きく天井てんじょうにうつっていたのです。赤ひげの人は、なにかなつかしそうにわらいながら、ジョバンニやカムパネルラのようすを見ていました。汽車はもうだんだん早くなって、すすきと川と、かわるがわる窓まどの外から光りました。
赤ひげの人が、少しおずおずしながら、二人に訊ききました。
「あなた方は、どちらへいらっしゃるんですか」
「どこまでも行くんです」ジョバンニは、少しきまり悪わるそうに答えました。
「それはいいね。この汽車は、じっさい、どこまででも行きますぜ」
「あなたはどこへ行くんです」カムパネルラが、いきなり、喧嘩けんかのようにたずねましたので、ジョバンニは思わずわらいました。すると、向むこうの席せきにいた、とがった帽子ぼうしをかぶり、大きな鍵かぎを腰こしに下げた人も、ちらっとこっちを見てわらいましたので、カムパネルラも、つい顔を赤くして笑わらいだしてしまいました。ところがその人は別べつにおこったでもなく、頬ほおをぴくぴくしながら返事へんじをしました。
「わっしはすぐそこで降おります。わっしは、鳥をつかまえる商売しょうばいでね」
「何鳥ですか」
「鶴つるや雁がんです。さぎも白鳥もです」
「鶴つるはたくさんいますか」
「いますとも、さっきから鳴いてまさあ。聞かなかったのですか」
「いいえ」
「いまでも聞こえるじゃありませんか。そら、耳をすまして聴きいてごらんなさい」
二人ふたりは眼めを挙あげ、耳をすましました。ごとごと鳴る汽車のひびきと、すすきの風との間から、ころんころんと水の湧わくような音が聞こえて来るのでした。
「鶴つる、どうしてとるんですか」
「鶴つるですか、それとも鷺さぎですか」
「鷺さぎです」ジョバンニは、どっちでもいいと思いながら答えました。
「そいつはな、雑作ぞうさない。さぎというものは、みんな天の川の砂すなが凝かたまって、ぼおっとできるもんですからね、そして始終しじゅう川へ帰りますからね、川原で待まっていて、鷺さぎがみんな、脚あしをこういうふうにしておりてくるとこを、そいつが地べたへつくかつかないうちに、ぴたっと押おさえちまうんです。するともう鷺さぎは、かたまって安心あんしんして死しんじまいます。あとはもう、わかり切ってまさあ。押おし葉ばにするだけです」
「鷺さぎを押おし葉ばにするんですか。標本ひょうほんですか」
「標本ひょうほんじゃありません。みんなたべるじゃありませんか」
「おかしいねえ」カムパネルラが首くびをかしげました。
「おかしいも不審ふしんもありませんや。そら」その男は立って、網棚あみだなから包つつみをおろして、手ばやくくるくると解ときました。
「さあ、ごらんなさい。いまとって来たばかりです」
「ほんとうに鷺さぎだねえ」二人ふたりは思わず叫さけびました。まっ白な、あのさっきの北の十字架じゅうじかのように光る鷺さぎのからだが、十ばかり、少しひらべったくなって、黒い脚あしをちぢめて、浮彫うきぼりのようにならんでいたのです。
「眼めをつぶってるね」カムパネルラは、指ゆびでそっと、鷺さぎの三日月みかづきがたの白いつぶった眼めにさわりました。頭の上の槍やりのような白い毛もちゃんとついていました。
「ね、そうでしょう」鳥捕とりとりは風呂敷ふろしきを重かさねて、またくるくると包つつんで紐ひもでくくりました。誰だれがいったいここらで鷺さぎなんぞたべるだろうとジョバンニは思いながら訊ききました。
「鷺さぎはおいしいんですか」
「ええ、毎日注文ちゅうもんがあります。しかし雁がんの方が、もっと売れます。雁がんの方がずっと柄がらがいいし、第一だいいち手数てすうがありませんからな。そら」鳥捕とりとりは、また別べつの方の包つつみを解ときました。すると黄と青じろとまだらになって、なにかのあかりのようにひかる雁がんが、ちょうどさっきの鷺さぎのように、くちばしをそろえて、少しひらべったくなって、ならんでいました。
「こっちはすぐたべられます。どうです、少しおあがりなさい」鳥捕とりとりは、黄いろの雁がんの足を、軽かるくひっぱりました。するとそれは、チョコレートででもできているように、すっときれいにはなれました。
「どうです。すこしたべてごらんなさい」鳥捕とりとりは、それを二つにちぎってわたしました。ジョバンニは、ちょっとたべてみて、
（なんだ、やっぱりこいつはお菓子かしだ。チョコレートよりも、もっとおいしいけれども、こんな雁がんが飛とんでいるもんか。この男は、どこかそこらの野原の菓子屋かしやだ。けれどもぼくは、このひとをばかにしながら、この人のお菓子かしをたべているのは、たいへんきのどくだ）とおもいながら、やっぱりぽくぽくそれをたべていました。
「も少しおあがりなさい」鳥捕とりとりがまた包つつみを出しました。ジョバンニは、もっとたべたかったのですけれども、
「ええ、ありがとう」といって遠慮えんりょしましたら、鳥捕とりとりは、こんどは向むこうの席せきの、鍵かぎをもった人に出しました。
「いや、商売しょうばいものをもらっちゃすみませんな」その人は、帽子ぼうしをとりました。
「いいえ、どういたしまして。どうです、今年の渡わたり鳥どりの景気けいきは」
「いや、すてきなもんですよ。一昨日おとといの第二限だいにげんころなんか、なぜ燈台とうだいの灯ひを、規則以外きそくいがいに間（一時空白）させるかって、あっちからもこっちからも、電話で故障こしょうが来ましたが、なあに、こっちがやるんじゃなくて、渡わたり鳥どりどもが、まっ黒にかたまって、あかしの前を通るのですからしかたありませんや、わたしぁ、べらぼうめ、そんな苦情くじょうは、おれのとこへ持もって来たってしかたがねえや、ばさばさのマントを着きて脚あしと口との途方とほうもなく細ほそい大将たいしょうへやれって、こう言いってやりましたがね、はっは」
すすきがなくなったために、向むこうの野原から、ぱっとあかりが射さして来ました。
「鷺さぎの方はなぜ手数てすうなんですか」カムパネルラは、さっきから、訊きこうと思っていたのです。
「それはね、鷺さぎをたべるには」鳥捕とりとりは、こっちに向むき直なおりました。「天の川の水あかりに、十日もつるしておくかね、そうでなけぁ、砂すなに三、四日うずめなけぁいけないんだ。そうすると、水銀すいぎんがみんな蒸発じょうはつして、たべられるようになるよ」
「こいつは鳥じゃない。ただのお菓子かしでしょう」やっぱりおなじことを考えていたとみえて、カムパネルラが、思い切ったというように、尋たずねました。鳥捕とりとりは、何かたいへんあわてたふうで、
「そうそう、ここで降おりなけぁ」と言いいながら、立って荷物にもつをとったと思うと、もう見えなくなっていました。
「どこへ行ったんだろう」二人ふたりは顔を見合わせましたら、燈台守とうだいもりは、にやにや笑わらって、少し伸のびあがるようにしながら、二人の横よこの窓まどの外をのぞきました。二人ふたりもそっちを見ましたら、たったいまの鳥捕とりとりが、黄いろと青じろの、うつくしい燐光りんこうを出す、いちめんのかわらははこぐさの上に立って、まじめな顔をして両手りょうてをひろげて、じっとそらを見ていたのです。
「あすこへ行ってる。ずいぶん奇体きたいだねえ。きっとまた鳥をつかまえるとこだねえ。汽車が走って行かないうちに、早く鳥がおりるといいな」と言いったとたん、がらんとした桔梗ききょういろの空から、さっき見たような鷺さぎが、まるで雪の降ふるように、ぎゃあぎゃあ叫さけびながら、いっぱいに舞まいおりて来ました。するとあの鳥捕とりとりは、すっかり注文ちゅうもん通りだというようにほくほくして、両足りょうあしをかっきり六十度どに開いて立って、鷺さぎのちぢめて降おりて来る黒い脚あしを両手りょうてで片かたっぱしから押おさえて、布ぬのの袋ふくろの中に入れるのでした。すると鷺さぎは、蛍ほたるのように、袋ふくろの中でしばらく、青くぺかぺか光ったり消きえたりしていましたが、おしまいとうとう、みんなぼんやり白くなって、眼めをつぶるのでした。ところが、つかまえられる鳥よりは、つかまえられないで無事ぶじに天の川の砂すなの上に降おりるものの方が多おおかったのです。それは見ていると、足が砂すなへつくや否いなや、まるで雪ゆきの解とけるように、縮ちぢまってひらべったくなって、まもなく溶鉱炉ようこうろから出た銅どうの汁しるのように、砂すなや砂利じゃりの上にひろがり、しばらくは鳥の形が、砂すなについているのでしたが、それも二、三度ど明るくなったり暗くらくなったりしているうちに、もうすっかりまわりと同じいろになってしまうのでした。
鳥捕とりとりは、二十疋ぴきばかり、袋ふくろに入れてしまうと、急きゅうに両手りょうてをあげて、兵隊へいたいが鉄砲弾てっぽうだまにあたって、死しぬときのような形をしました。と思ったら、もうそこに鳥捕とりとりの形はなくなって、かえって、
「ああせいせいした。どうもからだにちょうど合うほど稼かせいでいるくらい、いいことはありませんな」というききおぼえのある声が、ジョバンニの隣となりにしました。見ると鳥捕とりとりは、もうそこでとって来た鷺さぎを、きちんとそろえて、一つずつ重かさね直なおしているのでした。
「どうして、あすこから、いっぺんにここへ来たんですか」ジョバンニが、なんだかあたりまえのような、あたりまえでないような、おかしな気がして問といました。
「どうしてって、来ようとしたから来たんです。ぜんたいあなた方は、どちらからおいでですか」
ジョバンニは、すぐ返事へんじをしようと思いましたけれども、さあ、ぜんたいどこから来たのか、もうどうしても考えつきませんでした。カムパネルラも、顔をまっ赤にして何か思い出そうとしているのでした。
「ああ、遠くからですね」鳥捕とりとりは、わかったというように雑作ぞうさなくうなずきました。

九　ジョバンニの切符きっぷ

「もうここらは白鳥区くのおしまいです。ごらんなさい。あれが名高いアルビレオの観測所かんそくじょです」
窓まどの外の、まるで花火でいっぱいのような、あまの川のまん中に、黒い大きな建物たてものが四棟むねばかり立って、その一つの平屋根ひらやねの上に、眼めもさめるような、青宝玉サファイアと黄玉トパーズの大きな二つのすきとおった球たまが、輪わになってしずかにくるくるとまわっていました。黄いろのがだんだん向むこうへまわって行って、青い小さいのがこっちへ進すすんで来、まもなく二つのはじは、重かさなり合って、きれいな緑みどりいろの両面凸りょうめんとつレンズのかたちをつくり、それもだんだん、まん中がふくらみだして、とうとう青いのは、すっかりトパーズの正面しょうめんに来ましたので、緑みどりの中心と黄いろな明るい環わとができました。それがまただんだん横よこへ外それて、前のレンズの形を逆ぎゃくにくり返かえし、とうとうすっとはなれて、サファイアは向むこうへめぐり、黄いろのはこっちへ進すすみ、またちょうどさっきのようなふうになりました。銀河ぎんがの、かたちもなく音もない水にかこまれて、ほんとうにその黒い測候所そっこうじょが、睡ねむっているように、しずかによこたわったのです。
「あれは、水の速はやさをはかる器械きかいです。水も……」鳥捕とりとりが言いいかけたとき、
「切符きっぷを拝見はいけんいたします」三人の席せきの横よこに、赤い帽子ぼうしをかぶったせいの高い車掌しゃしょうが、いつかまっすぐに立っていて言いいました。鳥捕とりとりは、だまってかくしから、小さな紙きれを出しました。車掌しゃしょうはちょっと見て、すぐ眼めをそらして（あなた方のは？）というように、指ゆびをうごかしながら、手をジョバンニたちの方へ出しました。
「さあ」ジョバンニは困こまって、もじもじしていましたら、カムパネルラはわけもないというふうで、小さな鼠ねずみいろの切符きっぷを出しました。ジョバンニは、すっかりあわててしまって、もしか上着うわぎのポケットにでも、はいっていたかとおもいながら、手を入れてみましたら、何か大きなたたんだ紙きれにあたりました。こんなものはいっていたろうかと思って、急いそいで出してみましたら、それは四つに折おったはがきぐらいの大さ［＃「大さ」はママ］の緑みどりいろの紙でした。車掌しゃしょうが手を出しているもんですからなんでもかまわない、やっちまえと思って渡わたしましたら、車掌しゃしょうはまっすぐに立ち直なおってていねいにそれを開いて見ていました。そして読みながら上着うわぎのぼたんやなんかしきりに直なおしたりしていましたし燈台看守とうだいかんしゅも下からそれを熱心ねっしんにのぞいていましたから、ジョバンニはたしかにあれは証明書しょうめいしょか何かだったと考えて少し胸むねが熱あつくなるような気がしました。
「これは三次空間じくうかんの方からお持もちになったのですか」車掌しゃしょうがたずねました。
「なんだかわかりません」もう大丈夫だいじょうぶだと安心しながらジョバンニはそっちを見あげてくつくつ笑わらいました。
「よろしゅうございます。南十字サウザンクロスへ着つきますのは、次つぎの第だい三時ころになります」車掌しゃしょうは紙をジョバンニに渡わたして向むこうへ行きました。
カムパネルラは、その紙切れが何だったか待まちかねたというように急いそいでのぞきこみました。ジョバンニも全まったく早く見たかったのです。ところがそれはいちめん黒い唐草からくさのような模様もようの中に、おかしな十ばかりの字を印刷いんさつしたもので、だまって見ているとなんだかその中へ吸すい込こまれてしまうような気がするのでした。すると鳥捕とりとりが横からちらっとそれを見てあわてたように言いいました。
「おや、こいつはたいしたもんですぜ。こいつはもう、ほんとうの天上へさえ行ける切符きっぷだ。天上どこじゃない、どこでもかってにあるける通行券つうこうけんです。こいつをお持もちになれぁ、なるほど、こんな不完全ふかんぜんな幻想第四次げんそうだいよじの銀河鉄道ぎんがてつどうなんか、どこまででも行けるはずでさあ、あなた方たいしたもんですね」
「なんだかわかりません」ジョバンニが赤くなって答えながら、それをまたたたんでかくしに入れました。そしてきまりが悪わるいのでカムパネルラと二人ふたり、また窓まどの外をながめていましたが、その鳥捕とりとりの時々たいしたもんだというように、ちらちらこっちを見ているのがぼんやりわかりました。
「もうじき鷲わしの停車場ていしゃじょうだよ」カムパネルラが向むこう岸ぎしの、三つならんだ小さな青じろい三角標さんかくひょうと、地図とを見くらべて言いいました。
ジョバンニはなんだかわけもわからずに、にわかにとなりの鳥捕とりとりがきのどくでたまらなくなりました。鷺さぎをつかまえてせいせいしたとよろこんだり、白いきれでそれをくるくる包つつんだり、ひとの切符きっぷをびっくりしたように横目よこめで見てあわててほめだしたり、そんなことを一々考えていると、もうその見ず知らずの鳥捕とりとりのために、ジョバンニの持もっているものでも食べるものでもなんでもやってしまいたい、もうこの人のほんとうの幸さいわいになるなら、自分があの光る天の川の河原かわらに立って百年つづけて立って鳥をとってやってもいいというような気がして、どうしてももう黙だまっていられなくなりました。ほんとうにあなたのほしいものはいったい何ですかと訊きこうとして、それではあんまり出し抜ぬけだから、どうしようかと考えてふり返かえって見ましたら、そこにはもうあの鳥捕とりとりがいませんでした。網棚あみだなの上には白い荷物にもつも見えなかったのです。また窓まどの外で足をふんばってそらを見上げて鷺さぎを捕とるしたくをしているのかと思って、急いそいでそっちを見ましたが、外はいちめんのうつくしい砂子すなごと白いすすきの波なみばかり、あの鳥捕とりとりの広いせなかもとがった帽子ぼうしも見えませんでした。
「あの人どこへ行ったろう」カムパネルラもぼんやりそう言いっていました。
「どこへ行ったろう。いったいどこでまたあうのだろう。僕ぼくはどうしても少しあの人に物ものを言いわなかったろう」
「ああ、僕ぼくもそう思っているよ」
「僕ぼくはあの人が邪魔じゃまなような気がしたんだ。だから僕ぼくはたいへんつらい」ジョバンニはこんなへんてこな気もちは、ほんとうにはじめてだし、こんなこと今まで言いったこともないと思いました。
「なんだか苹果りんごのにおいがする。僕ぼくいま苹果りんごのことを考えたためだろうか」カムパネルラが不思議ふしぎそうにあたりを見まわしました。
「ほんとうに苹果りんごのにおいだよ。それから野茨のいばらのにおいもする」
ジョバンニもそこらを見ましたがやっぱりそれは窓まどからでもはいって来るらしいのでした。いま秋だから野茨のいばらの花のにおいのするはずはないとジョバンニは思いました。
そしたらにわかにそこに、つやつやした黒い髪かみの六つばかりの男の子が赤いジャケツのぼたんもかけず、ひどくびっくりしたような顔をして、がたがたふるえてはだしで立っていました。隣となりには黒い洋服ようふくをきちんと着きたせいの高い青年がいっぱいに風に吹ふかれているけやきの木のような姿勢しせいで、男の子の手をしっかりひいて立っていました。
「あら、ここどこでしょう。まあ、きれいだわ」青年のうしろに、もひとり、十二ばかりの眼めの茶いろな可愛かわいらしい女の子が、黒い外套がいとうを着きて青年の腕うでにすがって不思議ふしぎそうに窓まどの外を見ているのでした。
「ああ、ここはランカシャイヤだ。いや、コンネクテカット州しゅうだ。いや、ああ、ぼくたちはそらへ来たのだ。わたしたちは天へ行くのです。ごらんなさい。あのしるしは天上のしるしです。もうなんにもこわいことありません。わたくしたちは神かみさまに召めされているのです」黒服くろふくの青年はよろこびにかがやいてその女の子に言いいました。けれどもなぜかまた額ひたいに深ふかく皺しわを刻きざんで、それにたいへんつかれているらしく、無理むりに笑わらいながら男の子をジョバンニのとなりにすわらせました。それから女の子にやさしくカムパネルラのとなりの席せきを指ゆびさしました。女の子はすなおにそこへすわって、きちんと両手りょうてを組み合わせました。
「ぼく、おおねえさんのとこへ行くんだよう」腰掛こしかけたばかりの男の子は顔を変へんにして燈台看守とうだいかんしゅの向むこうの席せきにすわったばかりの青年に言いいました。青年はなんとも言いえず悲かなしそうな顔をして、じっとその子の、ちぢれたぬれた頭を見ました。女の子は、いきなり両手りょうてを顔にあててしくしく泣ないてしまいました。
「お父さんやきくよねえさんはまだいろいろお仕事しごとがあるのです。けれどももうすぐあとからいらっしゃいます。それよりも、おっかさんはどんなに永ながく待まっていらっしゃったでしょう。わたしの大事だいじなタダシはいまどんな歌をうたっているだろう、雪ゆきの降ふる朝にみんなと手をつないで、ぐるぐるにわとこのやぶをまわってあそんでいるだろうかと考えたり、ほんとうに待まって心配しんぱいしていらっしゃるんですから、早く行って、おっかさんにお目にかかりましょうね」
「うん、だけど僕ぼく、船に乗のらなけぁよかったなあ」
「ええ、けれど、ごらんなさい、そら、どうです、あの立派りっぱな川、ね、あすこはあの夏じゅう、ツィンクル、ツィンクル、リトル、スターをうたってやすむとき、いつも窓まどからぼんやり白く見えていたでしょう。あすこですよ。ね、きれいでしょう、あんなに光っています」
泣ないていた姉あねもハンケチで眼めをふいて外を見ました。青年は教えるようにそっと姉弟きょうだいにまた言いいました。
「わたしたちはもう、なんにもかなしいことないのです。わたしたちはこんないいとこを旅たびして、じき神かみさまのとこへ行きます。そこならもう、ほんとうに明るくてにおいがよくて立派りっぱな人たちでいっぱいです。そしてわたしたちの代かわりにボートへ乗のれた人たちは、きっとみんな助たすけられて、心配しんぱいして待まっているめいめいのお父さんやお母さんや自分のお家へやら行くのです。さあ、もうじきですから元気を出しておもしろくうたって行きましょう」青年は男の子のぬれたような黒い髪かみをなで、みんなを慰なぐさめながら、自分もだんだん顔いろがかがやいてきました。
「あなた方はどちらからいらっしゃったのですか。どうなすったのですか」
さっきの燈台看守とうだいかんしゅがやっと少しわかったように青年にたずねました。青年はかすかにわらいました。
「いえ、氷山ひょうざんにぶっつかって船が沈しずみましてね、わたしたちはこちらのお父さんが急きゅうな用ようで二か月前、一足さきに本国へお帰りになったので、あとから発たったのです。私は大学へはいっていて、家庭教師かていきょうしにやとわれていたのです。ところがちょうど十二日目、今日か昨日きのうのあたりです、船が氷山ひょうざんにぶっつかって一ぺんに傾かたむきもう沈しずみかけました。月のあかりはどこかぼんやりありましたが、霧きりが非常ひじょうに深ふかかったのです。ところがボートは左舷さげんの方半分はんぶんはもうだめになっていましたから、とてもみんなは乗のり切らないのです。もうそのうちにも船は沈しずみますし、私は必死ひっしとなって、どうか小さな人たちを乗のせてくださいと叫さけびました。近くの人たちはすぐみちを開いて、そして子供たちのために祈いのってくれました。けれどもそこからボートまでのところには、まだまだ小さな子どもたちや親たちやなんかいて、とても押おしのける勇気ゆうきがなかったのです。それでもわたくしはどうしてもこの方たちをお助たすけするのが私の義務ぎむだと思いましたから前にいる子供らを押おしのけようとしました。けれどもまた、そんなにして助たすけてあげるよりはこのまま神かみの御前みまえにみんなで行く方が、ほんとうにこの方たちの幸福こうふくだとも思いました。それからまた、その神かみにそむく罪つみはわたくしひとりでしょってぜひとも助たすけてあげようと思いました。けれども、どうしても見ているとそれができないのでした。子どもらばかりのボートの中へはなしてやって、お母さんが狂気きょうきのようにキスを送おくりお父さんがかなしいのをじっとこらえてまっすぐに立っているなど、とてももう腸はらわたもちぎれるようでした。そのうち船はもうずんずん沈しずみますから、私たちはかたまって、もうすっかり覚悟かくごして、この人たち二人を抱だいて、浮うかべるだけは浮うかぼうと船の沈しずむのを待まっていました。誰だれが投なげたかライフヴイが一つ飛とんで来ましたけれどもすべってずうっと向むこうへ行ってしまいました。私は一生けん命めいで甲板かんぱんの格子こうしになったとこをはなして、三人それにしっかりとりつきました。どこからともなく三〇六番の声があがりました。たちまちみんなはいろいろな国語で一ぺんにそれをうたいました。そのときにわかに大きな音がして私たちは水に落おち、もう渦うずにはいったと思いながらしっかりこの人たちをだいて、それからぼうっとしたと思ったらもうここへ来ていたのです。この方たちのお母さんは一昨年さくねん没なくなられました。ええ、ボートはきっと助たすかったにちがいありません、なにせよほど熟練じゅくれんな水夫すいふたちが漕こいで、すばやく船からはなれていましたから」
そこらから小さな嘆息たんそくやいのりの声が聞こえジョバンニもカムパネルラもいままで忘わすれていたいろいろのことをぼんやり思い出して眼めが熱あつくなりました。
（ああ、その大きな海はパシフィックというのではなかったろうか。その氷山ひょうざんの流ながれる北のはての海で、小さな船に乗のって、風や凍こおりつく潮水しおみずや、はげしい寒さむさとたたかって、たれかが一生けんめいはたらいている。ぼくはそのひとにほんとうにきのどくでそしてすまないような気がする。ぼくはそのひとのさいわいのためにいったいどうしたらいいのだろう）
ジョバンニは首くびをたれて、すっかりふさぎ込こんでしまいました。
「なにがしあわせかわからないです。ほんとうにどんなつらいことでもそれがただしいみちを進すすむ中でのできごとなら、峠とうげの上りも下りもみんなほんとうの幸福こうふくに近づく一あしずつですから」
燈台守とうだいもりがなぐさめていました。
「ああそうです。ただいちばんのさいわいに至いたるためにいろいろのかなしみもみんなおぼしめしです」
青年が祈いのるようにそう答えました。
そしてあの姉弟きょうだいはもうつかれてめいめいぐったり席せきによりかかって睡ねむっていました。さっきのあのはだしだった足にはいつか白い柔やわらかな靴くつをはいていたのです。
ごとごとごとごと汽車はきらびやかな燐光りんこうの川の岸きしを進すすみました。向むこうの方の窓まどを見ると、野原はまるで幻燈げんとうのようでした。百も千もの大小さまざまの三角標さんかくひょう、その大きなものの上には赤い点々をうった測量旗そくりょうきも見え、野原のはらのはてはそれらがいちめん、たくさんたくさん集あつまってぼおっと青白い霧きりのよう、そこからか、またはもっと向むこうからか、ときどきさまざまの形のぼんやりした狼煙のろしのようなものが、かわるがわるきれいな桔梗ききょういろのそらにうちあげられるのでした。じつにそのすきとおった奇麗きれいな風は、ばらのにおいでいっぱいでした。
「いかがですか。こういう苹果りんごはおはじめてでしょう」向むこうの席せきの燈台看守とうだいかんしゅがいつか黄金きんと紅べにでうつくしくいろどられた大きな苹果りんごを落おとさないように両手りょうてで膝ひざの上にかかえていました。
「おや、どっから来たのですか。立派りっぱですねえ。ここらではこんな苹果りんごができるのですか」青年はほんとうにびっくりしたらしく、燈台看守とうだいかんしゅの両手りょうてにかかえられた一もりの苹果りんごを、眼めを細ほそくしたり首くびをまげたりしながら、われを忘わすれてながめていました。
「いや、まあおとりください。どうか、まあおとりください」
青年は一つとってジョバンニたちの方をちょっと見ました。
「さあ、向むこうの坊ぼっちゃんがた。いかがですか。おとりください」
ジョバンニは坊ぼっちゃんといわれたので、すこししゃくにさわってだまっていましたが、カムパネルラは、
「ありがとう」と言いいました。
すると青年は自分でとって一つずつ二人に送おくってよこしましたので、ジョバンニも立って、ありがとうと言いいました。
燈台看守とうだいかんしゅはやっと両腕りょううでがあいたので、こんどは自分で一つずつ睡ねむっている姉弟きょうだいの膝ひざにそっと置おきました。
「どうもありがとう。どこでできるのですか。こんな立派りっぱな苹果りんごは」
青年はつくづく見ながら言いいました。
「この辺あたりではもちろん農業のうぎょうはいたしますけれどもたいていひとりでにいいものができるような約束やくそくになっております。農業のうぎょうだってそんなにほねはおれはしません。たいてい自分の望のぞむ種子たねさえ播まけばひとりでにどんどんできます。米だってパシフィック辺へんのように殻からもないし十倍ばいも大きくてにおいもいいのです。けれどもあなたがたのいらっしゃる方なら農業のうぎょうはもうありません。苹果りんごだってお菓子かしだって、かすが少しもありませんから、みんなそのひとそのひとによってちがった、わずかのいいかおりになって毛あなからちらけてしまうのです」
にわかに男の子がばっちり眼めをあいて言いいました。
「ああぼくいまお母っかさんの夢ゆめをみていたよ。お母っかさんがね、立派りっぱな戸棚とだなや本のあるとこにいてね、ぼくの方を見て手をだしてにこにこにこにこわらったよ。ぼく、おっかさん。りんごをひろってきてあげましょうか、と言いったら眼めがさめちゃった。ああここ、さっきの汽車のなかだねえ」
「その苹果りんごがそこにあります。このおじさんにいただいたのですよ」青年が言いいました。
「ありがとうおじさん。おや、かおるねえさんまだねてるねえ、ぼくおこしてやろう。ねえさん。ごらん、りんごをもらったよ。おきてごらん」
姉あねはわらって眼めをさまし、まぶしそうに両手りょうてを眼めにあてて、それから苹果りんごを見ました。
男の子はまるでパイをたべるように、もうそれをたべていました。またせっかくむいたそのきれいな皮かわも、くるくるコルク抜ぬきのような形になって床ゆかへ落おちるまでの間にはすうっと、灰はいいろに光って蒸発じょうはつしてしまうのでした。
二人ふたりはりんごをたいせつにポケットにしまいました。
川下の向むこう岸ぎしに青く茂しげった大きな林が見え、その枝えだには熟じゅくしてまっ赤に光るまるい実みがいっぱい、その林のまん中に高い高い三角標さんかくひょうが立って、森の中からはオーケストラベルやジロフォンにまじってなんとも言いえずきれいな音ねいろが、とけるように浸しみるように風につれて流ながれて来るのでした。
青年はぞくっとしてからだをふるうようにしました。
だまってその譜ふを聞いていると、そこらにいちめん黄いろや、うすい緑みどりの明るい野原のはらか敷物しきものかがひろがり、またまっ白な蝋ろうのような露つゆが太陽たいようの面めんをかすめて行くように思われました。
「まあ、あの烏からす」カムパネルラのとなりの、かおると呼よばれた女の子が叫さけびました。
「からすでない。みんなかささぎだ」カムパネルラがまた何気なくしかるように叫さけびましたので、ジョバンニはまた思わず笑わらい、女の子はきまり悪わるそうにしました。まったく河原かわらの青じろいあかりの上に、黒い鳥がたくさんたくさんいっぱいに列れつになってとまってじっと川の微光びこうを受けているのでした。
「かささぎですねえ、頭のうしろのとこに毛がぴんと延のびてますから」青年はとりなすように言いいました。
向むこうの青い森の中の三角標さんかくひょうはすっかり汽車の正面しょうめんに来ました。そのとき汽車のずうっとうしろの方から、あの聞きなれた三〇六番の讃美歌さんびかのふしが聞こえてきました。よほどの人数で合唱がっしょうしているらしいのでした。青年はさっと顔いろが青ざめ、たって一ぺんそっちへ行きそうにしましたが思いかえしてまたすわりました。かおる子はハンケチを顔にあててしまいました。
ジョバンニまでなんだか鼻はなが変へんになりました。けれどもいつともなく誰だれともなくその歌は歌い出されだんだんはっきり強くなりました。思わずジョバンニもカムパネルラもいっしょにうたいだしたのです。
そして青い橄欖かんらんの森が、見えない天の川の向むこうにさめざめと光りながらだんだんうしろの方へ行ってしまい、そこから流ながれて来るあやしい楽器がっきの音も、もう汽車のひびきや風の音にすりへらされてずうっとかすかになりました。
「あ、孔雀くじゃくがいるよ。あ、孔雀くじゃくがいるよ」
「あの森琴ライラの宿やどでしょう。あたしきっとあの森の中にむかしの大きなオーケストラの人たちが集あつまっていらっしゃると思うわ、まわりには青い孔雀くじゃくやなんかたくさんいると思うわ」
「ええ、たくさんいたわ」女の子がこたえました。
ジョバンニはその小さく小さくなっていまはもう一つの緑みどりいろの貝かいぼたんのように見える森の上にさっさっと青じろく時々光ってその孔雀くじゃくがはねをひろげたりとじたりする光の反射はんしゃを見ました。
「そうだ、孔雀くじゃくの声だってさっき聞こえた」カムパネルラが女の子に言いいました。
「ええ、三十疋ぴきぐらいはたしかにいたわ」女の子が答えました。
ジョバンニはにわかになんとも言いえずかなしい気がして思わず、
「カムパネルラ、ここからはねおりて遊あそんで行こうよ」とこわい顔をして言いおうとしたくらいでした。
ところがそのときジョバンニは川下の遠くの方に不思議ふしぎなものを見ました。それはたしかになにか黒いつるつるした細長ほそながいもので、あの見えない天の川の水の上に飛とび出してちょっと弓ゆみのようなかたちに進すすんで、また水の中にかくれたようでした。おかしいと思ってまたよく気をつけていましたら、こんどはずっと近くでまたそんなことがあったらしいのでした。そのうちもうあっちでもこっちでも、その黒いつるつるした変へんなものが水から飛とび出して、まるく飛とんでまた頭から水へくぐるのがたくさん見えてきました。みんな魚のように川上へのぼるらしいのでした。
「まあ、なんでしょう。たあちゃん。ごらんなさい。まあたくさんだわね。なんでしょうあれ」
睡ねむそうに眼めをこすっていた男の子はびっくりしたように立ちあがりました。
「なんだろう」青年も立ちあがりました。
「まあ、おかしな魚だわ、なんでしょうあれ」
「海豚いるかです」カムパネルラがそっちを見ながら答えました。
「海豚いるかだなんてあたしはじめてだわ。けどここ海じゃないんでしょう」
「いるかは海にいるときまっていない」あの不思議ふしぎな低ひくい声がまたどこからかしました。
ほんとうにそのいるかのかたちのおかしいことは、二つのひれをちょうど両手りょうてをさげて不動ふどうの姿勢しせいをとったようなふうにして水の中から飛とび出して来て、うやうやしく頭を下にして不動ふどうの姿勢しせいのまままた水の中へくぐって行くのでした。見えない天の川の水もそのときはゆらゆらと青い焔ほのおのように波なみをあげるのでした。
「いるかお魚でしょうか」女の子がカムパネルラにはなしかけました。男の子はぐったりつかれたように席せきにもたれて睡ねむっていました。
「いるか、魚じゃありません。くじらと同じようなけだものです」カムパネルラが答えました。
「あなたくじら見たことあって」
「僕ぼくあります。くじら、頭と黒いしっぽだけ見えます。潮しおを吹ふくとちょうど本にあるようになります」
「くじらなら大きいわねえ」
「くじら大きいです。子供こどもだっているかぐらいあります」
「そうよ、あたしアラビアンナイトで見たわ」姉あねは細ほそい銀ぎんいろの指輪ゆびわをいじりながらおもしろそうにはなししていました。
（カムパネルラ、僕ぼくもう行っちまうぞ。僕ぼくなんか鯨くじらだって見たことないや）
ジョバンニはまるでたまらないほどいらいらしながら、それでも堅かたく、唇くちびるを噛かんでこらえて窓まどの外を見ていました。その窓まどの外には海豚いるかのかたちももう見えなくなって川は二つにわかれました。そのまっくらな島しまのまん中に高い高いやぐらが一つ組まれて、その上に一人の寛ゆるい服ふくを着きて赤い帽子ぼうしをかぶった男が立っていました。そして両手りょうてに赤と青の旗はたをもってそらを見上げて信号しんごうしているのでした。
ジョバンニが見ている間その人はしきりに赤い旗はたをふっていましたが、にわかに赤旗あかはたをおろしてうしろにかくすようにし、青い旗はたを高く高くあげてまるでオーケストラの指揮者しきしゃのようにはげしく振ふりました。すると空中にざあっと雨のような音がして、何かまっくらなものが、いくかたまりもいくかたまりも鉄砲丸てっぽうだまのように川の向むこうの方へ飛とんで行くのでした。ジョバンニは思わず窓まどからからだを半分出して、そっちを見あげました。美うつくしい美うつくしい桔梗ききょういろのがらんとした空の下を、実じつに何万なんまんという小さな鳥どもが、幾組いくくみも幾組いくくみもめいめいせわしくせわしく鳴いて通って行くのでした。
「鳥が飛とんで行くな」ジョバンニが窓まどの外で言いました。
「どら」カムパネルラもそらを見ました。
そのときあのやぐらの上のゆるい服ふくの男はにわかに赤い旗はたをあげて狂気きょうきのようにふりうごかしました。するとぴたっと鳥の群むれは通らなくなり、それと同時にぴしゃあんというつぶれたような音が川下の方で起おこって、それからしばらくしいんとしました。と思ったらあの赤帽あかぼうの信号手しんごうしゅがまた青い旗はたをふって叫さけんでいたのです。
「いまこそわたれわたり鳥、いまこそわたれわたり鳥」その声もはっきり聞こえました。
それといっしょにまた幾万いくまんという鳥の群むれがそらをまっすぐにかけたのです。二人ふたりの顔を出しているまん中の窓まどからあの女の子が顔を出して美うつくしい頬ほおをかがやかせながらそらを仰あおぎました。
「まあ、この鳥、たくさんですわねえ、あらまあそらのきれいなこと」女の子はジョバンニにはなしかけましたけれどもジョバンニは生意気なまいきな、いやだいと思いながら、だまって口をむすんでそらを見あげていました。女の子は小さくほっと息いきをして、だまって席せきへ戻もどりました。カムパネルラがきのどくそうに窓まどから顔を引っ込こめて地図を見ていました。
「あの人鳥へ教えてるんでしょうか」女の子がそっとカムパネルラにたずねました。
「わたり鳥へ信号しんごうしてるんです。きっとどこからかのろしがあがるためでしょう」
カムパネルラが少しおぼつかなそうに答えました。そして車の中はしいんとなりました。ジョバンニはもう頭を引っ込こめたかったのですけれども明るいとこへ顔を出すのがつらかったので、だまってこらえてそのまま立って口笛くちぶえを吹ふいていました。
（どうして僕ぼくはこんなにかなしいのだろう。僕ぼくはもっとこころもちをきれいに大きくもたなければいけない。あすこの岸きしのずうっと向むこうにまるでけむりのような小さな青い火が見える。あれはほんとうにしずかでつめたい。僕ぼくはあれをよく見てこころもちをしずめるんだ）
ジョバンニは熱ほてって痛いたいあたまを両手りょうてで押おさえるようにして、そっちの方を見ました。
（ああほんとうにどこまでもどこまでも僕ぼくといっしょに行くひとはないだろうか。カムパネルラだってあんな女の子とおもしろそうに談はなしているし僕ぼくはほんとうにつらいなあ）
ジョバンニの眼めはまた泪なみだでいっぱいになり、天の川もまるで遠くへ行いったようにぼんやり白く見えるだけでした。
そのとき汽車はだんだん川からはなれて崖がけの上を通るようになりました。向むこう岸ぎしもまた黒いいろの崖がけが川の岸きしを下流かりゅうに下るにしたがって、だんだん高くなっていくのでした。そしてちらっと大きなとうもろこしの木を見ました。その葉ははぐるぐるに縮ちぢれ葉はの下にはもう美しい緑みどりいろの大きな苞ほうが赤い毛を吐はいて真珠しんじゅのような実みもちらっと見えたのでした。それはだんだん数を増ましてきて、もういまは列れつのように崖がけと線路せんろとの間にならび、思わずジョバンニが窓まどから顔を引っ込こめて向むこう側がわの窓まどを見ましたときは、美うつくしいそらの野原の地平線ちへいせんのはてまで、その大きなとうもろこしの木がほとんどいちめんに植うえられて、さやさや風にゆらぎ、その立派りっぱなちぢれた葉はのさきからは、まるでひるの間にいっぱい日光を吸すった金剛石こんごうせきのように露つゆがいっぱいについて、赤や緑みどりやきらきら燃もえて光っているのでした。カムパネルラが、
「あれとうもろこしだねえ」とジョバンニに言いいましたけれども、ジョバンニはどうしても気持きもちがなおりませんでしたから、ただぶっきらぼうに野原を見たまま、
「そうだろう」と答えました。
そのとき汽車はだんだんしずかになって、いくつかのシグナルとてんてつ器きの灯あかりを過ぎ、小さな停車場ていしゃばにとまりました。
その正面しょうめんの青じろい時計とけいはかっきり第二時だいにじを示しめし、風もなくなり汽車もうごかず、しずかなしずかな野原のなかにその振ふり子こはカチッカチッと正しく時を刻きざんでいくのでした。
そしてまったくその振ふり子この音のたえまを遠くの遠くの野原のはてから、かすかなかすかな旋律せんりつが糸のように流ながれて来るのでした。
「新世界交響楽しんせかいこうきょうがくだわ」向むこうの席せきの姉あねがひとりごとのようにこっちを見ながらそっと言いいました。
全まったくもう車の中ではあの黒服くろふくの丈高たけたかい青年も誰だれもみんなやさしい夢ゆめを見ているのでした。
（こんなしずかないいとこで僕ぼくはどうしてもっと愉快ゆかいになれないだろう。どうしてこんなにひとりさびしいのだろう。けれどもカムパネルラなんかあんまりひどい、僕ぼくといっしょに汽車に乗のっていながら、まるであんな女の子とばかり談はなしているんだもの。僕ぼくはほんとうにつらい）
ジョバンニはまた手で顔を半分はんぶんかくすようにして向むこうの窓まどのそとを見つめていました。
すきとおった硝子ガラスのような笛ふえが鳴って汽車はしずかに動きだし、カムパネルラもさびしそうに星めぐりの口笛くちぶえを吹ふきました。
「ええ、ええ、もうこの辺へんはひどい高原ですから」
うしろの方で誰だれかとしよりらしい人の、いま眼めがさめたというふうではきはき談はなしている声がしました。
「とうもろこしだって棒ぼうで二尺も孔あなをあけておいてそこへ播まかないとはえないんです」
「そうですか。川まではよほどありましょうかねえ」
「ええ、ええ、河かわまでは二千尺じゃくから六千尺じゃくあります。もうまるでひどい峡谷きょうこくになっているんです」
そうそうここはコロラドの高原じゃなかったろうか、ジョバンニは思わずそう思いました。
あの姉あねは弟を自分の胸むねによりかからせて睡ねむらせながら黒い瞳ひとみをうっとりと遠くへ投なげて何を見るでもなしに考え込こんでいるのでしたし、カムパネルラはまださびしそうにひとり口笛くちぶえを吹ふき、男の子はまるで絹きぬで包つつんだ苹果りんごのような顔いろをしてジョバンニの見る方を見ているのでした。
突然とつぜんとうもろこしがなくなって巨おおきな黒い野原のはらがいっぱいにひらけました。
新世界交響楽しんせかいこうきょうがくはいよいよはっきり地平線ちへいせんのはてから湧わき、そのまっ黒な野原のはらのなかを一人のインデアンが白い鳥の羽根はねを頭につけ、たくさんの石を腕うでと胸むねにかざり、小さな弓ゆみに矢やをつがえていちもくさんに汽車を追おって来るのでした。
「あら、インデアンですよ。インデアンですよ。おねえさまごらんなさい」
黒服くろふくの青年も眼めをさましました。
ジョバンニもカムパネルラも立ちあがりました。
「走って来るわ、あら、走って来るわ。追おいかけているんでしょう」
「いいえ、汽車を追おってるんじゃないんですよ。猟りょうをするか踊おどるかしてるんですよ」
青年はいまどこにいるか忘わすれたというふうにポケットに手を入れて立ちながら言いいました。
まったくインデアンは半分はんぶんは踊おどっているようでした。第一だいいちかけるにしても足のふみようがもっと経済けいざいもとれ本気にもなれそうでした。にわかにくっきり白いその羽根はねは前の方へ倒たおれるようになり、インデアンはぴたっと立ちどまって、すばやく弓ゆみを空にひきました。そこから一羽わの鶴つるがふらふらと落おちて来て、また走り出したインデアンの大きくひろげた両手りょうてに落おちこみました。インデアンはうれしそうに立ってわらいました。そしてその鶴つるをもってこっちを見ている影かげも、もうどんどん小さく遠くなり、電しんばしらの碍子がいしがきらっきらっと続つづいて二つばかり光って、またとうもろこしの林になってしまいました。こっち側がわの窓まどを見ますと汽車はほんとうに高い高い崖がけの上を走っていて、その谷の底そこには川がやっぱり幅はばひろく明るく流ながれていたのです。
「ええ、もうこの辺へんから下りです。なんせこんどは一ぺんにあの水面すいめんまでおりて行くんですから容易よういじゃありません。この傾斜けいしゃがあるもんですから汽車は決けっして向むこうからこっちへは来ないんです。そら、もうだんだん早くなったでしょう」さっきの老人ろうじんらしい声が言いいました。
どんどんどんどん汽車は降おりて行きました。崖がけのはじに鉄道てつどうがかかるときは川が明るく下にのぞけたのです。ジョバンニはだんだんこころもちが明るくなってきました。汽車が小さな小屋こやの前を通って、その前にしょんぼりひとりの子供こどもが立ってこっちを見ているときなどは思わず、ほう、と叫さけびました。
どんどんどんどん汽車は走って行きました。室中へやじゅうのひとたちは半分はんぶんうしろの方へ倒たおれるようになりながら腰掛こしかけにしっかりしがみついていました。ジョバンニは思わずカムパネルラとわらいました。もうそして天の川は汽車のすぐ横手よこてをいままでよほど激はげしく流ながれて来たらしく、ときどきちらちら光ってながれているのでした。うすあかい河原かわらなでしこの花があちこち咲さいていました。汽車はようやく落おち着ついたようにゆっくり走っていました。
向むこうとこっちの岸きしに星のかたちとつるはしを書いた旗はたがたっていました。
「あれなんの旗はただろうね」ジョバンニがやっとものを言いいました。
「さあ、わからないねえ、地図にもないんだもの。鉄てつの舟ふねがおいてあるねえ」
「ああ」
「橋はしを架かけるとこじゃないんでしょうか」女の子が言いいました。
「ああ、あれ工兵こうへいの旗はただねえ。架橋演習かきょうえんしゅうをしてるんだ。けれど兵隊へいたいのかたちが見えないねえ」
その時向むこう岸ぎしちかくの少し下流かりゅうの方で、見えない天の川の水がぎらっと光って、柱はしらのように高くはねあがり、どおとはげしい音がしました。
「発破はっぱだよ、発破はっぱだよ」カムパネルラはこおどりしました。
その柱はしらのようになった水は見えなくなり、大きな鮭さけや鱒ますがきらっきらっと白く腹はらを光らせて空中にほうり出されてまるい輪わを描えがいてまた水に落おちました。ジョバンニはもうはねあがりたいくらい気持きもちが軽かるくなって言いいました。
「空の工兵大隊こうへいだいたいだ。どうだ、鱒ますなんかがまるでこんなになってはねあげられたねえ。僕ぼくこんな愉快ゆかいな旅たびはしたことない。いいねえ」
「あの鱒ますなら近くで見たらこれくらいあるねえ、たくさんさかないるんだな、この水の中に」
「小さなお魚もいるんでしょうか」女の子が談はなしにつり込こまれて言いいました。
「いるんでしょう。大きなのがいるんだから小さいのもいるんでしょう。けれど遠くだから、いま小さいの見えなかったねえ」ジョバンニはもうすっかり機嫌きげんが直なおっておもしろそうにわらって女の子に答えました。
「あれきっと双子ふたごのお星さまのお宮みやだよ」男の子がいきなり窓まどの外をさして叫さけびました。
右手の低ひくい丘おかの上に小さな水晶すいしょうででもこさえたような二つのお宮みやがならんで立っていました。
「双子ふたごのお星さまのお宮みやってなんだい」
「あたし前になんべんもお母っかさんから聞いたわ。ちゃんと小さな水晶すいしょうのお宮みやで二つならんでいるからきっとそうだわ」
「はなしてごらん。双子ふたごのお星さまが何をしたっての」
「ぼくも知ってらい。双子ふたごのお星さまが野原へ遊あそびにでて、からすと喧嘩けんかしたんだろう」
「そうじゃないわよ。あのね、天の川の岸きしにね、おっかさんお話しなすったわ、……」
「それから彗星ほうきぼしがギーギーフーギーギーフーて言いって来たねえ」
「いやだわ、たあちゃん、そうじゃないわよ。それはべつの方だわ」
「するとあすこにいま笛ふえを吹ふいているんだろうか」
「いま海へ行ってらあ」
「いけないわよ。もう海からあがっていらっしゃったのよ」
「そうそう。ぼく知ってらあ、ぼくおはなししよう」

川の向こう岸ぎしがにわかに赤くなりました。
楊やなぎの木や何かもまっ黒にすかし出され、見えない天の川の波なみも、ときどきちらちら針はりのように赤く光りました。まったく向むこう岸ぎしの野原に大きなまっ赤な火が燃もやされ、その黒いけむりは高く桔梗ききょういろのつめたそうな天をも焦こがしそうでした。ルビーよりも赤くすきとおり、リチウムよりもうつくしく酔よったようになって、その火は燃もえているのでした。
「あれはなんの火だろう。あんな赤く光る火は何を燃もやせばできるんだろう」ジョバンニが言いいました。
「蠍さそりの火だな」カムパネルラがまた地図と首くびっぴきして答えました。
「あら、蠍さそりの火のことならあたし知ってるわ」
「蠍さそりの火ってなんだい」ジョバンニがききました。
「蠍さそりがやけて死んだのよ。その火がいまでも燃もえてるって、あたし何べんもお父さんから聴きいたわ」
「蠍さそりって、虫だろう」
「ええ、蠍さそりは虫よ。だけどいい虫だわ」
「蠍さそりいい虫じゃないよ。僕ぼく博物館はくぶつかんでアルコールにつけてあるの見た。尾おにこんなかぎがあってそれで螫さされると死しぬって先生が言いってたよ」
「そうよ。だけどいい虫だわ、お父さんこう言いったのよ。むかしのバルドラの野原に一ぴきの蠍さそりがいて小さな虫やなんか殺ころしてたべて生きていたんですって。するとある日いたちに見つかって食べられそうになったんですって。さそりは一生けん命めいにげてにげたけど、とうとういたちに押おさえられそうになったわ、そのときいきなり前に井戸いどがあってその中に落おちてしまったわ、もうどうしてもあがられないで、さそりはおぼれはじめたのよ。そのときさそりはこう言いってお祈いのりしたというの。
ああ、わたしはいままで、いくつのものの命いのちをとったかわからない、そしてその私がこんどいたちにとられようとしたときはあんなに一生けん命めいにげた。それでもとうとうこんなになってしまった。ああなんにもあてにならない。どうしてわたしはわたしのからだを、だまっていたちにくれてやらなかったろう。そしたらいたちも一日生きのびたろうに。どうか神かみさま。私の心をごらんください。こんなにむなしく命いのちをすてず、どうかこの次つぎには、まことのみんなの幸さいわいのために私のからだをおつかいください。って言いったというの。
そしたらいつか蠍さそりはじぶんのからだが、まっ赤なうつくしい火になって燃もえて、よるのやみを照てらしているのを見たって。いまでも燃もえてるってお父さんおっしゃったわ。ほんとうにあの火、それだわ」
「そうだ。見たまえ。そこらの三角標さんかくひょうはちょうどさそりの形にならんでいるよ」
ジョバンニはまったくその大きな火の向むこうに三つの三角標さんかくひょうが、ちょうどさそりの腕うでのように、こっちに五つの三角標さんかくひょうがさそりの尾おやかぎのようにならんでいるのを見ました。そしてほんとうにそのまっ赤なうつくしいさそりの火は音なくあかるくあかるく燃もえたのです。
その火がだんだんうしろの方になるにつれて、みんなはなんとも言いえずにぎやかな、さまざまの楽がくの音ねや草花のにおいのようなもの、口笛くちぶえや人々のざわざわ言いう声やらを聞きました。それはもうじきちかくに町か何かがあって、そこにお祭まつりでもあるというような気がするのでした。
「ケンタウル露つゆをふらせ」いきなりいままで睡ねむっていたジョバンニのとなりの男の子が向むこうの窓まどを見ながら叫さけんでいました。
ああそこにはクリスマストリイのようにまっ青な唐檜とうひかもみの木がたって、その中にはたくさんのたくさんの豆電燈まめでんとうがまるで千の蛍ほたるでも集あつまったようについていました。
「ああ、そうだ、今夜ケンタウル祭さいだねえ」
「ああ、ここはケンタウルの村だよ」カムパネルラがすぐ言いいました。
（此この間原稿げんこうなし）
「ボール投げなら僕ぼく決けっしてはずさない」
男の子が大いばりで言いいました。
「もうじきサウザンクロスです。おりるしたくをしてください」青年がみんなに言いいました。
「僕ぼく、も少し汽車に乗ってるんだよ」男の子が言いいました。
カムパネルラのとなりの女の子はそわそわ立ってしたくをはじめましたけれどもやっぱりジョバンニたちとわかれたくないようなようすでした。
「ここでおりなけぁいけないのです」青年はきちっと口を結むすんで男の子を見おろしながら言いいました。
「厭いやだい。僕ぼくもう少し汽車へ乗のってから行くんだい」
ジョバンニがこらえかねて言いいました。
「僕ぼくたちといっしょに乗のって行こう。僕ぼくたちどこまでだって行ける切符きっぷ持もってるんだ」
「だけどあたしたち、もうここで降おりなけぁいけないのよ。ここ天上へ行くとこなんだから」
女の子がさびしそうに言いいました。
「天上へなんか行かなくたっていいじゃないか。ぼくたちここで天上よりももっといいとこをこさえなけぁいけないって僕ぼくの先生が言いったよ」
「だっておっ母かさんも行ってらっしゃるし、それに神かみさまがおっしゃるんだわ」
「そんな神かみさまうその神かみさまだい」
「あなたの神かみさまうその神かみさまよ」
「そうじゃないよ」
「あなたの神かみさまってどんな神かみさまですか」青年は笑わらいながら言いいました。
「ぼくほんとうはよく知りません。けれどもそんなんでなしに、ほんとうのたった一人ひとりの神かみさまです」
「ほんとうの神かみさまはもちろんたった一人ひとりです」
「ああ、そんなんでなしに、たったひとりのほんとうのほんとうの神かみさまです」
「だからそうじゃありませんか。わたくしはあなた方がいまにそのほんとうの神かみさまの前に、わたくしたちとお会いになることを祈いのります」青年はつつましく両手りょうてを組みました。
女の子もちょうどその通りにしました。みんなほんとうに別わかれが惜おしそうで、その顔いろも少し青ざめて見えました。ジョバンニはあぶなく声をあげて泣なき出そうとしました。
「さあもうしたくはいいんですか。じきサウザンクロスですから」
ああそのときでした。見えない天の川のずうっと川下に青や橙だいだいや、もうあらゆる光でちりばめられた十字架じゅうじかが、まるで一本の木というふうに川の中から立ってかがやき、その上には青じろい雲がまるい環わになって後光のようにかかっているのでした。汽車の中がまるでざわざわしました。みんなあの北の十字のときのようにまっすぐに立ってお祈いのりをはじめました。あっちにもこっちにも子供が瓜うりに飛とびついたときのようなよろこびの声や、なんとも言いようない深ふかいつつましいためいきの音ばかりきこえました。そしてだんだん十字架じゅうじかは窓まどの正面しょうめんになり、あの苹果りんごの肉にくのような青じろい環わの雲も、ゆるやかにゆるやかに繞めぐっているのが見えました。
「ハレルヤ、ハレルヤ」明るくたのしくみんなの声はひびき、みんなはそのそらの遠くから、つめたいそらの遠くから、すきとおったなんとも言いえずさわやかなラッパの声をききました。そしてたくさんのシグナルや電燈でんとうの灯あかりのなかを汽車はだんだんゆるやかになり、とうとう十字架じゅうじかのちょうどま向むかいに行ってすっかりとまりました。
「さあ、おりるんですよ」青年は男の子の手をひき姉あねは互たがいにえりや肩かたをなおしてやってだんだん向むこうの出口の方へ歩き出しました。
「じゃさよなら」女の子がふりかえって二人に言いいました。
「さよなら」ジョバンニはまるで泣なき出したいのをこらえておこったようにぶっきらぼうに言いいました。
女の子はいかにもつらそうに眼めを大きくして、も一度どこっちをふりかえって、それからあとはもうだまって出て行ってしまいました。汽車の中はもう半分以上はんぶんいじょうも空すいてしまいにわかにがらんとして、さびしくなり風がいっぱいに吹ふき込こみました。
そして見ているとみんなはつつましく列れつを組んで、あの十字架じゅうじかの前の天の川のなぎさにひざまずいていました。そしてその見えない天の川の水をわたって、ひとりのこうごうしい白いきものの人が手をのばしてこっちへ来るのを二人は見ました。けれどもそのときはもう硝子ガラスの呼よび子は鳴らされ汽車はうごきだし、と思ううちに銀ぎんいろの霧きりが川下の方から、すうっと流ながれて来て、もうそっちは何も見えなくなりました。ただたくさんのくるみの木が葉はをさんさんと光らしてその霧きりの中に立ち、黄金きんの円光をもった電気栗鼠でんきりすが可愛かわいい顔をその中からちらちらのぞいているだけでした。
そのとき、すうっと霧きりがはれかかりました。どこかへ行く街道かいどうらしく小さな電燈でんとうの一列いちれつについた通りがありました。それはしばらく線路せんろに沿そって進すすんでいました。そして二人ふたりがそのあかしの前を通って行くときは、その小さな豆いろの火はちょうどあいさつでもするようにぽかっと消きえ、二人ふたりが過ぎて行くときまた点つくのでした。
ふりかえって見ると、さっきの十字架じゅうじかはすっかり小さくなってしまい、ほんとうにもうそのまま胸むねにもつるされそうになり、さっきの女の子や青年たちがその前の白い渚なぎさにまだひざまずいているのか、それともどこか方角ほうがくもわからないその天上へ行ったのか、ぼんやりして見分けられませんでした。
ジョバンニは、ああ、と深ふかく息いきしました。
「カムパネルラ、また僕ぼくたち二人ふたりきりになったねえ、どこまでもどこまでもいっしょに行こう。僕ぼくはもう、あのさそりのように、ほんとうにみんなの幸さいわいのためならば僕ぼくのからだなんか百ぺん灼やいてもかまわない」
「うん。僕ぼくだってそうだ」カムパネルラの眼めにはきれいな涙なみだがうかんでいました。
「けれどもほんとうのさいわいはいったいなんだろう」
ジョバンニが言いいました。
「僕ぼくわからない」カムパネルラがぼんやり言いいました。
「僕ぼくたちしっかりやろうねえ」ジョバンニが胸むねいっぱい新しい力が湧わくように、ふうと息いきをしながら言いいました。
「あ、あすこ石炭袋せきたんぶくろだよ。そらの孔あなだよ」カムパネルラが少しそっちを避さけるようにしながら天の川のひととこを指ゆびさしました。
ジョバンニはそっちを見て、まるでぎくっとしてしまいました。天の川の一とこに大きなまっくらな孔あなが、どおんとあいているのです。その底そこがどれほど深ふかいか、その奥おくに何があるか、いくら眼めをこすってのぞいてもなんにも見えず、ただ眼めがしんしんと痛いたむのでした。ジョバンニが言いいました。
「僕ぼくもうあんな大きな暗やみの中だってこわくない。きっとみんなのほんとうのさいわいをさがしに行く。どこまでもどこまでも僕ぼくたちいっしょに進すすんで行こう」
「ああきっと行くよ。ああ、あすこの野原はなんてきれいだろう。みんな集あつまってるねえ。あすこがほんとうの天上なんだ。あっ、あすこにいるのはぼくのお母さんだよ」
カムパネルラはにわかに窓まどの遠くに見えるきれいな野原を指さして叫さけびました。
ジョバンニもそっちを見ましたけれども、そこはぼんやり白くけむっているばかり、どうしてもカムパネルラが言いったように思われませんでした。
なんとも言いえずさびしい気がして、ぼんやりそっちを見ていましたら、向むこうの河岸かわぎしに二本の電信でんしんばしらが、ちょうど両方りょうほうから腕うでを組んだように赤い腕木うでぎをつらねて立っていました。
「カムパネルラ、僕ぼくたちいっしょに行こうねえ」ジョバンニがこう言いいながらふりかえって見ましたら、そのいままでカムパネルラのすわっていた席せきに、もうカムパネルラの形は見えず、ただ黒いびろうどばかりひかっていました。
ジョバンニはまるで鉄砲丸てっぽうだまのように立ちあがりました。そして誰だれにも聞こえないように窓まどの外へからだを乗のり出して、力いっぱいはげしく胸むねをうって叫さけび、それからもう咽喉のどいっぱい泣なきだしました。
もうそこらが一ぺんにまっくらになったように思いました。そのとき、
「おまえはいったい何を泣ないているの。ちょっとこっちをごらん」いままでたびたび聞こえた、あのやさしいセロのような声が、ジョバンニのうしろから聞こえました。
ジョバンニは、はっと思って涙なみだをはらってそっちをふり向むきました、さっきまでカムパネルラのすわっていた席せきに黒い大きな帽子ぼうしをかぶった青白い顔のやせた大人おとなが、やさしくわらって大きな一冊さつの本をもっていました。
「おまえのともだちがどこかへ行ったのだろう。あのひとはね、ほんとうにこんや遠くへ行ったのだ。おまえはもうカムパネルラをさがしてもむだだ」
「ああ、どうしてなんですか。ぼくはカムパネルラといっしょにまっすぐに行こうと言いったんです」
「ああ、そうだ。みんながそう考える。けれどもいっしょに行けない。そしてみんながカムパネルラだ。おまえがあうどんなひとでも、みんな何べんもおまえといっしょに苹果りんごをたべたり汽車に乗のったりしたのだ。だからやっぱりおまえはさっき考えたように、あらゆるひとのいちばんの幸福こうふくをさがし、みんなといっしょに早くそこに行くがいい、そこでばかりおまえはほんとうにカムパネルラといつまでもいっしょに行けるのだ」
「ああぼくはきっとそうします。ぼくはどうしてそれをもとめたらいいでしょう」
「ああわたくしもそれをもとめている。おまえはおまえの切符きっぷをしっかりもっておいで。そして一しんに勉強べんきょうしなけぁいけない。おまえは化学かがくをならったろう、水は酸素さんそと水素すいそからできているということを知っている。いまはたれだってそれを疑うたがやしない。実験じっけんしてみるとほんとうにそうなんだから。けれども昔むかしはそれを水銀すいぎんと塩しおでできていると言いったり、水銀すいぎんと硫黄いおうでできていると言いったりいろいろ議論ぎろんしたのだ。みんながめいめいじぶんの神かみさまがほんとうの神さまだというだろう、けれどもお互たがいほかの神かみさまを信しんずる人たちのしたことでも涙なみだがこぼれるだろう。それからぼくたちの心がいいとかわるいとか議論ぎろんするだろう。そして勝負しょうぶがつかないだろう。けれども、もしおまえがほんとうに勉強べんきょうして実験じっけんでちゃんとほんとうの考えと、うその考えとを分けてしまえば、その実験じっけんの方法ほうほうさえきまれば、もう信仰しんこうも化学かがくと同じようになる。けれども、ね、ちょっとこの本をごらん、いいかい、これは地理ちりと歴史れきしの辞典じてんだよ。この本のこの頁ページはね、紀元前きげんぜん二千二百年の地理ちりと歴史れきしが書いてある。よくごらん、紀元前きげんぜん二千二百年のことでないよ、紀元前きげんぜん二千二百年のころにみんなが考えていた地理ちりと歴史れきしというものが書いてある。
だからこの頁ページ一つが一冊さつの地歴ちれきの本にあたるんだ。いいかい、そしてこの中に書いてあることは紀元前きげんぜん二千二百年ころにはたいてい本当ほんとうだ。さがすと証拠しょうこもぞくぞく出ている。けれどもそれが少しどうかなとこう考えだしてごらん、そら、それは次つぎの頁ページだよ。
紀元前きげんぜん一千年。だいぶ、地理ちりも歴史れきしも変かわってるだろう。このときにはこうなのだ。変へんな顔をしてはいけない。ぼくたちはぼくたちのからだだって考えだって、天の川だって汽車だって歴史れきしだって、ただそう感じているのなんだから、そらごらん、ぼくといっしょにすこしこころもちをしずかにしてごらん。いいか」
そのひとは指ゆびを一本あげてしずかにそれをおろしました。するといきなりジョバンニは自分というものが、じぶんの考えというものが、汽車やその学者がくしゃや天の川や、みんないっしょにぽかっと光って、しいんとなくなって、ぽかっとともってまたなくなって、そしてその一つがぽかっとともると、あらゆる広ひろい世界せかいががらんとひらけ、あらゆる歴史れきしがそなわり、すっと消きえると、もうがらんとした、ただもうそれっきりになってしまうのを見ました。だんだんそれが早くなって、まもなくすっかりもとのとおりになりました。
「さあいいか。だからおまえの実験じっけんは、このきれぎれの考えのはじめから終おわりすべてにわたるようでなければいけない。それがむずかしいことなのだ。けれども、もちろんそのときだけのでもいいのだ。ああごらん、あすこにプレシオスが見える。おまえはあのプレシオスの鎖くさりを解とかなければならない」
そのときまっくらな地平線ちへいせんの向むこうから青じろいのろしが、まるでひるまのようにうちあげられ、汽車の中はすっかり明るくなりました。そしてのろしは高くそらにかかって光りつづけました。
「ああマジェランの星雲せいうんだ。さあもうきっと僕ぼくは僕ぼくのために、僕ぼくのお母さんのために、カムパネルラのために、みんなのために、ほんとうのほんとうの幸福こうふくをさがすぞ」
ジョバンニは唇くちびるを噛かんで、そのマジェランの星雲せいうんをのぞんで立ちました。そのいちばん幸福こうふくなそのひとのために！
「さあ、切符きっぷをしっかり持もっておいで。お前はもう夢ゆめの鉄道てつどうの中でなしにほんとうの世界せかいの火やはげしい波なみの中を大股おおまたにまっすぐに歩いて行かなければいけない。天の川のなかでたった一つの、ほんとうのその切符きっぷを決けっしておまえはなくしてはいけない」
あのセロのような声がしたと思うとジョバンニは、あの天の川がもうまるで遠く遠くなって風が吹ふき自分はまっすぐに草の丘おかに立っているのを見、また遠くからあのブルカニロ博士はかせの足おとのしずかに近づいて来るのをききました。
「ありがとう。私はたいへんいい実験じっけんをした。私はこんなしずかな場所ばしょで遠くから私の考えを人に伝つたえる実験じっけんをしたいとさっき考えていた。お前の言いった語はみんな私の手帳てちょうにとってある。さあ帰っておやすみ。お前は夢ゆめの中で決心けっしんしたとおりまっすぐに進すすんで行くがいい。そしてこれからなんでもいつでも私のとこへ相談そうだんにおいでなさい」
「僕ぼくきっとまっすぐに進すすみます。きっとほんとうの幸福こうふくを求もとめます」ジョバンニは力強ちからづよく言いいました。
「ああではさよなら。これはさっきの切符きっぷです」
博士はかせは小さく折おった緑みどりいろの紙をジョバンニのポケットに入れました。そしてもうそのかたちは天気輪てんきりんの柱はしらの向むこうに見えなくなっていました。
ジョバンニはまっすぐに走って丘おかをおりました。
そしてポケットがたいへん重おもくカチカチ鳴るのに気がつきました。林の中でとまってそれをしらべてみましたら、あの緑みどりいろのさっき夢ゆめの中で見たあやしい天の切符きっぷの中に大きな二枚まいの金貨きんかが包つつんでありました。
「博士はかせありがとう、おっかさん。すぐ乳ちちをもって行きますよ」
ジョバンニは叫さけんでまた走りはじめました。何かいろいろのものが一ぺんにジョバンニの胸むねに集あつまってなんとも言いえずかなしいような新しいような気がするのでした。
琴ことの星がずうっと西の方へ移うつってそしてまた夢ゆめのように足をのばしていました。

ジョバンニは眼めをひらきました。もとの丘おかの草の中につかれてねむっていたのでした。胸むねはなんだかおかしく熱ほてり、頬ほおにはつめたい涙なみだがながれていました。
ジョバンニはばねのようにはね起おきました。町はすっかりさっきの通りに下でたくさんの灯あかりを綴つづってはいましたが、その光はなんだかさっきよりは熱ねっしたというふうでした。
そしてたったいま夢ゆめであるいた天の川もやっぱりさっきの通りに白くぼんやりかかり、まっ黒な南の地平線ちへいせんの上ではことにけむったようになって、その右には蠍座さそりざの赤い星がうつくしくきらめき、そらぜんたいの位置いちはそんなに変かわってもいないようでした。
ジョバンニはいっさんに丘おかを走って下りました。まだ夕ごはんをたべないで待まっているお母さんのことが胸むねいっぱいに思いだされたのです。どんどん黒い松まつの林の中を通って、それからほの白い牧場ぼくじょうの柵さくをまわって、さっきの入口から暗くらい牛舎ぎゅうしゃの前へまた来ました。そこには誰だれかがいま帰ったらしく、さっきなかった一つの車が何かの樽たるを二つ載のっけて置おいてありました。
「今晩こんばんは」ジョバンニは叫さけびました。
「はい」白い太いずぼんをはいた人がすぐ出て来て立ちました。
「なんのご用ですか」
「今日牛乳ぎゅうにゅうがぼくのところへ来なかったのですが」
「あ、済すみませんでした」その人はすぐ奥おくへ行って一本の牛乳瓶ぎゅうにゅうびんをもって来てジョバンニに渡わたしながら、また言いいました。
「ほんとうに済すみませんでした。今日はひるすぎ、うっかりしてこうしの柵さくをあけておいたもんですから、大将たいしょうさっそく親牛おやうしのところへ行って半分はんぶんばかりのんでしまいましてね……」その人はわらいました。
「そうですか。ではいただいて行きます」
「ええ、どうも済すみませんでした」
「いいえ」
ジョバンニはまだ熱あつい乳ちちの瓶びんを両方りょうほうのてのひらで包つつむようにもって牧場ぼくじょうの柵さくを出ました。
そしてしばらく木のある町を通って大通りへ出てまたしばらく行きますとみちは十文字になって、その右手の方、通りのはずれにさっきカムパネルラたちのあかりを流ながしに行った川へかかった大きな橋はしのやぐらが夜のそらにぼんやり立っていました。
ところがその十字になった町かどや店の前に女たちが七、八人ぐらいずつ集あつまって橋はしの方を見ながら何かひそひそ談はなしているのです。それから橋はしの上にもいろいろなあかりがいっぱいなのでした。
ジョバンニはなぜかさあっと胸むねが冷つめたくなったように思いました。そしていきなり近くの人たちへ、
「何かあったんですか」と叫さけぶようにききました。
「こどもが水へ落おちたんですよ」一人ひとりが言いいますと、その人たちは一斉いっせいにジョバンニの方を見ました。ジョバンニはまるで夢中むちゅうで橋はしの方へ走りました。橋はしの上は人でいっぱいで河かわが見えませんでした。白い服ふくを着きた巡査じゅんさも出ていました。
ジョバンニは橋はしの袂たもとから飛とぶように下の広い河原かわらへおりました。
その河原かわらの水ぎわに沿そってたくさんのあかりがせわしくのぼったり下ったりしていました。向むこう岸ぎしの暗くらいどてにも火が七つ八つうごいていました。そのまん中をもう烏瓜からすうりのあかりもない川が、わずかに音をたてて灰はいいろにしずかに流ながれていたのでした。
河原かわらのいちばん下流かりゅうの方へ洲すのようになって出たところに人の集あつまりがくっきりまっ黒に立っていました。ジョバンニはどんどんそっちへ走りました。するとジョバンニはいきなりさっきカムパネルラといっしょだったマルソに会あいました。マルソがジョバンニに走り寄よって言いいました。
「ジョバンニ、カムパネルラが川へはいったよ」
「どうして、いつ」
「ザネリがね、舟ふねの上から烏からすうりのあかりを水の流ながれる方へ押おしてやろうとしたんだ。そのとき舟ふねがゆれたもんだから水へ落おっこったろう。するとカムパネルラがすぐ飛とびこんだんだ。そしてザネリを舟ふねの方へ押おしてよこした。ザネリはカトウにつかまった。けれどもあとカムパネルラが見えないんだ」
「みんなさがしてるんだろう」
「ああ、すぐみんな来た。カムパネルラのお父さんも来た。けれども見つからないんだ。ザネリはうちへ連つれられてった」
ジョバンニはみんなのいるそっちの方へ行きました。そこに学生たちや町の人たちに囲かこまれて青じろいとがったあごをしたカムパネルラのお父さんが黒い服ふくを着きてまっすぐに立って左手に時計とけいを持もってじっと見つめていたのです。
みんなもじっと河かわを見ていました。誰だれも一言ひとことも物ものを言いう人もありませんでした。ジョバンニはわくわくわくわく足がふるえました。魚をとるときのアセチレンランプがたくさんせわしく行ったり来たりして、黒い川の水はちらちら小さな波なみをたてて流ながれているのが見えるのでした。
下流かりゅうの方の川はばいっぱい銀河ぎんがが巨おおきく写うつって、まるで水のないそのままのそらのように見えました。
ジョバンニは、そのカムパネルラはもうあの銀河ぎんがのはずれにしかいないというような気がしてしかたなかったのです。
けれどもみんなはまだ、どこかの波なみの間から、
「ぼくずいぶん泳およいだぞ」と言いながらカムパネルラが出て来るか、あるいはカムパネルラがどこかの人の知らない洲すにでも着ついて立っていて誰だれかの来るのを待まっているかというような気がしてしかたないらしいのでした。けれどもにわかにカムパネルラのお父さんがきっぱり言いいました。
「もう駄目だめです。落おちてから四十五分たちましたから」
ジョバンニは思わずかけよって博士はかせの前に立って、ぼくはカムパネルラの行った方を知っています、ぼくはカムパネルラといっしょに歩いていたのです、と言いおうとしましたが、もうのどがつまってなんとも言いえませんでした。すると博士はかせはジョバンニがあいさつに来たとでも思ったものですか、しばらくしげしげジョバンニを見ていましたが、
「あなたはジョバンニさんでしたね。どうも今晩こんばんはありがとう」とていねいに言いいました。
ジョバンニは何も言いえずにただおじぎをしました。
「あなたのお父さんはもう帰っていますか」博士はかせは堅かたく時計とけいを握にぎったまま、またききました。
「いいえ」ジョバンニはかすかに頭をふりました。
「どうしたのかなあ、ぼくには一昨日おとといたいへん元気な便たよりがあったんだが。今日きょうあたりもう着つくころなんだが。船ふねが遅おくれたんだな。ジョバンニさん。あした放課後ほうかごみなさんとうちへ遊あそびに来てくださいね」
そう言いいながら博士はかせはまた、川下の銀河ぎんがのいっぱいにうつった方へじっと眼めを送おくりました。
ジョバンニはもういろいろなことで胸むねがいっぱいで、なんにも言いえずに博士はかせの前をはなれて、早くお母さんに牛乳ぎゅうにゅうを持もって行って、お父さんの帰ることを知らせようと思うと、もういちもくさんに河原かわらを街まちの方へ走りました。
EOT;

    protected static function explode($text)
    {
        $chars = [];

        foreach (preg_split('//u', preg_replace('/\s+/u', '', $text)) as $char) {
            if ($char !== '') {
                $chars[] = $char;
            }
        }

        return $chars;
    }

    protected static function strlen($text)
    {
        return function_exists('mb_strlen') ? mb_strlen($text, 'UTF-8') : count(static::explode($text));
    }

    protected static function validStart($word)
    {
        return !in_array($word, static::$notBeginPunct, false);
    }

    protected static function appendEnd($text)
    {
        // extract the last char of $text
        if (function_exists('mb_substr')) {
            $last = mb_substr($text, 0, mb_strlen($text) - 1, 'UTF-8');
        } else {
            $chars = static::split($text);
            $last = end($chars);
        }
        // if the last char is a not-valid-end punctuation, remove it
        if (in_array($last, static::$notEndPunct, false)) {
            $text = preg_replace('/.$/u', '', $text);
        }
        // if the last char is not a valid punctuation, append a default one.
        return in_array($last, static::$endPunct, false) ? $text : $text . '。';
    }
}
